<?php
/*
Copyright 2001,2002,2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

This file is part of phpWebApp.

phpWebApp is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

phpWebApp is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with phpWebApp; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  
*/

/**
 * This class is used for opening a connection with a database
 * and for executing a query. This is like an interface, which
 * is implemented by DB specific classes.
 * 
 * @package database
 */
class Connection
{
  /** The connection to the DB. */
  var $cnn;

  /**
   * Opens a connection using the given parameters.
   * If no parameters are given, then uses as default values
   * the constants declared in 'config/const.DB.php'.
   * Each DB specific connection must declare its constructer
   * like this one.
   */
  function Connection($host =DBHOST, $user =DBUSER, 
                      $passw =DBPASS, $db_name =DBNAME)
    {
      //empty function
    }
        
  /** 
   * Returns a two-dimentional array, indexed by
   * row nr and field name, if query is a SELECT;
   * returns 'true' or 'false' if query does not return a result.
   */
  function execQuery($query, $query_id =UNDEFINED)
    {
      global $webPage;

      $proc_id = $this->get_proc_id($query_id);
      $webPage->timer->Start($proc_id, $query);
      $result = $this->exec_query($query);
      $webPage->timer->Stop($proc_id);
                
      return $result;
    }

  /**
   * Database specific function that executes the query
   * and returns a two-dimentional array, or a boolean value.
   * It must be overriden by each DB specific class.
   */
  function exec_query($query)
    {
      //empty function
    }

  /**
   * Returns a process id to uniquely identify a query in the timer.
   */
  function get_proc_id($q_id =UNDEFINED)
    {
      if (!EXECUTION_TIME_INFO)  return;

      global $webPage;
      static $id = "_001";
                
      if ($q_id===UNDEFINED)
        {
          $proc_id = "query".$id++;
        }
      else
        {
          $proc_id = "rs_".$q_id;
          if (isset($webPage->timer->info[$proc_id]))     $proc_id .= "_01";
          while (isset($webPage->timer->info[$proc_id]))  $proc_id++;
        }

      return $proc_id;
    }
}
?>