<?php
/*
Copyright 2001,2002,2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

This file is part of phpWebApp.

phpWebApp is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

phpWebApp is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with phpWebApp; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  
*/


/**
 * @package parser
 */
class Template
{
  /** Template id. */
  var $id;
      
  /** Template type:
   *  'Template', 'If', 'Repeat', 'WebBox', 
   *  'IfEmpty', 'Header', 'Footer' */
  var $type;    

  /** The parent template */
  var $parent;  
      
  /** Array that keeps the variables of the template. */
  var $vars;    

  /** The lines of the template (array of lines). */
  var $content; 


  /** Constructor */
  function Template($tplId =UNDEFINED, $type ="Template")
    {
      static $default_id = "Template_01";
                
      $this->id = ($tplId<>UNDEFINED ? $tplId : $default_id++);
      $this->type = $type;
      $this->vars = array();
      $this->content = array();
    }

  /** Adds a new variable in the array of variables. */
  function addVar($var_name, $expression)
    {
      $var_name = $var_name;
      $this->vars[$var_name] = $expression;
    }

  /** Returns an array with all the evaluated variables. */
  function getVars()
    {
      reset($this->vars);
      $tplVars = $this->vars;
      while ( list($var_name,$expr) = each($tplVars) )
        {
          $expr = WebApp::replaceVars($expr);
          $tplVars[$var_name] = WebApp::evaluate($expr);
        }
      return $tplVars;
    }
                
  /**#@+ Debug function. */
  function toHtmlTable()
    {
      $htmlTable = "
<br>
<a name='$this->id'>&nbsp;</a>[<a href='javascript: back()'>Back</a>]
<table width='90%' bgcolor='#aaaaaa' border='0' cellspacing='1' cellpadding='2'>
  <tr>
    <td bgcolor='#eeeeee' align='right' width='1%'>ID:</td>
    <td bgcolor='#eeeeff'>$this->id</td>
  </tr>
  <tr>
    <td bgcolor='#eeeeee' align='right'>Type:</td>
    <td bgcolor='#f9f9f9'>$this->type</td>      
  </tr>
" . $this->attribs2html() . "
  <tr><td colspan='2' bgcolor='#f9f9ff'>
" . $this->content2html() . "
  </td></tr>
</table>
";
                
      return $htmlTable;
    }

  /** @see toHtmlTable() */
  function attribs2html()
    { 
      reset($this->vars);
      while ( list($vname,$value) = each($this->vars) )
        {
          $vars .= " $vname=($value); ";
        }

      $html = "
  <tr>
    <td bgcolor='#eeeeee' valign='top' align='right'>Vars:</td>
    <td bgcolor='#f9f9f9'> $vars </td>
  </tr>";
      return $html;
    }

  /** @see toHtmlTable() */
  function content2html()
    {
      $html = "\n<pre class='webapp'>";
      $i = 0;
      while ($i < sizeof($this->content))
        {
          $line = $this->content[$i++];
          if (trim($line)=="##")
            {
              $line = $this->content[$i++];
              $tpl_id = trim($line);
              $html .= "<a href='#$tpl_id'>##\n$tpl_id</a>\n";
            }
          else
            {
              $html .= htmlentities($line);
            }
        }
      $html .= "</pre>\n";

      return $html;
    }
        
  /** Returns the structure of loaded templates as a tree. */
  function to_tree($indent)
    {
      //don't output the appended boxes
      if (ereg("web_app/append/append.html\$", $this->id))  return;

      global $webPage;
                
      $tree = $indent."|\n";
      $tree .= $indent."+--<a href='#".$this->id."'>".$this->id."</a>"
        . " (".$this->type.")\n";
      $i = 0;
      while ($i < sizeof($this->content))
        {
          $line = $this->content[$i++];
          if (trim($line)=="##")
            {
              $line = $this->content[$i++];
              $tpl_id = trim($line);
              $tpl = $webPage->getTemplate($tpl_id);
              $tree .= $tpl->to_tree($indent."|  ");
            }
        }
      return $tree;
    }
        
  /**
   * Prints a preview of this template only (without processing
   * subtemplates), for the benefit of the designer.
   */
  function print_preview()      
    {
      for ($i=0; $i < count($this->content); $i++)
        {
          $line = $this->content[$i];
          $line = WebApp::replaceVars($line);
          print "\t\t".$line;
        }
    }
  /**#@-*/
}
?>