<?php
/*
Copyright 2001,2002,2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

This file is part of phpWebApp.

phpWebApp is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

phpWebApp is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with phpWebApp; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  
*/


/**
 * The template of a <WebClass> element.
 * @package parser 
 */
class WebClassTpl extends Template
{
  /** Path where the WebClassTpl is located. */
  var $path;

  /** Array of parameters and their default values. */
  var $params;

  /** 
   * The number of the objects of this class. It is  
   * incremented each time that a new object is created. */
  var $obj_count; 

  function WebClassTpl($id, $path =UNDEFINED)
    {
      $this->Template($id, "WebClassTpl");
      $this->path = $path;
      $this->params = array();
      $this->obj_count = 0;
    }

  function before_parse()
    {
      //load the .db file of the webclass
      $this->parse_db_file();
        
      //include the PHP class of the webClass
      $this->include_php_class();

      //include the JS code of the webClass
      $this->include_js_code();

      //include the CSS code of the webClass
      $this->include_css_code();
    }
        
  /** Parse the .db file of the webclass, if it exists. */
  function parse_db_file()
    {
      $fname = $this->path.$this->id.".db";
      if (file_exists($fname))
        {
          //parse the file
          global $parser;
          $parser->silent = true;
          $parser->parse_file($fname);
          $parser->silent = false;
        }
    }

  /**
   * Looks for the PHP file in the same folder as WebClass
   * (with the same name as the webclass' ID) and includes it
   * if it exists; if not, define a dummy class for this webclass.
   */
  function include_php_class()
    {
      $fname = $this->path."/".$this->id.".php";
      if (file_exists($fname))
        {
          include_once $fname;
        }
      else
        {
          //create a dummy class for this WebClass
          $class_name = $this->id;
          $arr_methods = get_class_methods($class_name);
          if (sizeof($arr_methods)==0)
            {
              $dummy_class_definition = 
                "class $class_name extends WebObject 
                 {
                   /** 
                    * We declare a dummy method in this dummy class
                    * so that get_class_methods() doesn't return
                    * an empty array and we can check whether such a
                    * class has been defined before or not.
                    */
                   function $class_name() 
                     {
                     }
                 }";
              eval($dummy_class_definition);
            }   
        }
    }

  /**
   * Looks for the JS file in the same folder as WebClass
   * (with the same name as the webclass' ID) and includes it
   * in the <head> of the page, if it exists.
   */
  function include_js_code()
    {
      $fname = $this->path.$this->id.".js";
      if (file_exists($fname))
        {
          global $webPage;
          $fname = WebApp::to_url($fname);
          $include_js = "  <script language='JavaScript' src='$fname'></script>\n";
          $webPage->append_to_head($include_js);
        }
    }

  /**
   * Looks for the CSS file in the same folder as WebClass
   * (with the same name as the webclass' ID) and includes it
   * in the <head> of the page, if it exists.
   */
  function include_css_code()
    {
      $fname = $this->path.$this->id.".css";
      if (file_exists($fname))
        {
          global $webPage;
          $fname = WebApp::to_url($fname);
          $include_css = "  <link rel='stylesheet' href='$fname' type='text/css'>\n";
          $webPage->append_to_head($include_css);
        }
    }

  /** for debug */
  function attribs2html()
    {
      reset($this->params);
      while ( list($p_name,$expr) = each($this->params) )
        {
          $params .= " $p_name=($expr); ";
        }
      $html = Template::attribs2html() . "
  <tr>
    <td bgcolor='#eeeeee' valign='top' align='right'>Path:</td>
    <td bgcolor='#f9f9f9'>" . $this->path ." </td>
  </tr>
  <tr>
    <td bgcolor='#eeeeee' valign='top' align='right'>Params:</td>
    <td bgcolor='#f9f9f9'>" . $params ." </td>
  </tr>
";
      return $html;
    }
}
?>