<?php
/*
Copyright 2001,2002,2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

This file is part of phpWebApp.

phpWebApp is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

phpWebApp is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with phpWebApp; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  
*/


/**
 * @package     webobjects
 * @subpackage  formWebObj
 */
class formWebObj extends WebObject
{
  function afterParse()
    {
      global $webPage;

      //prepend js code to the content of this template
      $form_url = WebApp::to_url(FORM_PATH);
      $js_code = "<script language='JavaScript' "
        . "src='".$form_url."formWebObj.js'></script>\n";
      $webPage->append_to_head($js_code);
      //array_unshift($this->content, $js_code);

      //append js code to the content of this template
      global $formData;  //form data comes with transmitVar() as a global var
      if (isset($formData))
        {
          $form_name = $this->get_form_name();
          $js_code = "
<script language='JavaScript'>
  var form = document.$form_name;
  var formData = '$formData';
  setFormData(form, formData);
</script>
";
          array_push($this->content, $js_code);
        }
    }

  /** finds and returns the name of the form in this template */
  function get_form_name()
    {
      for ($i=0; $i < sizeof($this->content); $i++)
        {
          $line = $this->content[$i];
          if (Parser::get_tag_name($line)=="<form")
            {
              $form_name = Parser::get_attr_value($line, "name");
              break;
            }
        }
      return $form_name;
    }
}
?>