<?php
/*
Copyright 2001,2002,2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

This file is part of phpWebApp.

phpWebApp is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

phpWebApp is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with phpWebApp; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  
*/


/**
 * Class MenuElem represents an element of a menu.
 *
 * @package     boxes
 * @subpackage  editMenus
 */
class MenuElem
{
  var $id;                //identifies this menu element
  var $description;       //text that will be shown in the menu
  var $action;     //what will be done when this element is selected (typically a JS function call)
  var $parent;            //parent of this element in the hierarchy of the menu
  var $children;          //array of subelements

  function MenuElem($id =UNDEFINED, $descr ="menu element", $act ="")
    {
      $this->id = $id ;
      $this->description = $descr;
      $this->action = $act;
      $this->children = array();
    }
        
  /** builds a menu element from a DOMXML node */
  function build_from_dom($elem)
    {
      //get the attributes
      $this->id                               = $elem->getattr("id");
      $this->description              = $elem->getattr("description");
      $this->action                   = $elem->getattr("action");
      if ($this->description=="")             $this->description = $this->id;
      if ($this->action=="")                  $this->action = $this->id;

      //add the child elements
      $children = $elem->children();
      while ( list($i,$child) = each($children) )
        {
          if ($child->name=="MenuElem")
            {
              $sub_elem = new MenuElem;
              $sub_elem->build_from_dom($child);
              $this->addChild($sub_elem);
            }
        }
    }

  function addChild(&$ch)
    {
      $this->children[] = $ch;
      $ch->parent = &$this;
    }
        
  function nrChildren()
    {
      return sizeof($this->children);
    }

  function hasChildren()
    {
      $nr_ch = $this->nrChildren();
      return ($nr_ch <> 0);
    }

  /**
   * set the ids of the children (if unset)
   * used by the function that loads the menu from an xml file
   */
  function set_children_id()
    {
      for ($i=0; $i < $this->nrChildren(); $i++)
        {
          $child = &$this->children[$i];
          if ($child->id==UNDEFINED)
            {
              $child->id = $this->id . "_" . ($i+1);
            }
          $child->set_children_id();
        }
    }
        
  /** returns an id for a new child */
  function new_child_id()
    {
      $max_id = $this->id."_0";
      for ($i=0; $i < $this->nrChildren(); $i++)
        {
          $id = $this->children[$i]->id;
          if ($id > $max_id)      $max_id = $id;
        }
      $max_id++;
      return $max_id;
    }
        
  /** sets the action that is used when the menu is being edited */
  function setEditAction()
    {
      $id = $this->id;
      $descr = $this->description;
      $action = $this->action;
      $this->action = "edit(\\\"$id\\\", \\\"$descr\\\", \\\"$action\\\")";
      for ($i=0; $i < $this->nrChildren(); $i++)
        {
          $child = &$this->children[$i];
          $child->setEditAction();
        }
    }
        
  function change($id, $change_func)
    {
      for ($i=0; $i < $this->nrChildren(); $i++)
        {
          $child = &$this->children[$i];
          if ($child->id==$id)    
            {
              $change_func($this, $child);
              return true;
            }
          $changed = $child->change($id, $change_func);
          if ($changed) return true;
        }
                
      return false;
    }

  /////////// output functions /////////////
        
  /** returns the menu element as an xml string indented by $indent */
  function to_xml($indent)
    {
      $xml_menu = $indent.'<MenuElem id="'.$this->id."\"\n"
        . "\t\t".$indent.'description="'.$this->description."\"\n"
        . "\t\t".$indent.'action="'.$this->action."\">\n";
      $xml_menu .= $this->children_to_xml("\t".$indent);
      $xml_menu .= $indent."</MenuElem>\n";
      return $xml_menu;
    }
        
  /** returns the children as an xml string indented by $indent */
  function children_to_xml($indent)
    {
      for ($i=0; $i < $this->nrChildren(); $i++)
        {
          $child = $this->children[$i];
          $xml_menu .= $child->to_xml($indent);
        }
      return $xml_menu;
    }

  /**
   * returns the element and all its subelements
   * in an easily readable text format
   */
  function to_text($ident)                //debug
    {
      $txt_menu = $ident."> ".$this->id." -> ".$this->description." -> ".$this->action."\n";
      for ($i=0; $i < $this->nrChildren(); $i++)
        {
          $child = $this->children[$i];
          $txt_menu .= $child->to_text("\t".$ident);
        }
      return $txt_menu;
    }
        
  /**
   * prints the element and all its subelements
   * in an easily readable text format
   */
  function print_text($ident)             //debug
    {
      print $ident."> ".$this->id." -> ".$this->description." -> ".$this->action."\n";
      for ($i=0; $i < $this->nrChildren(); $i++)
        {
          $child = $this->children[$i];
          print $child->print_text("\t".$ident);
        }
    }

  /**
   * returns the branch starting with this element
   * in the JavaScript format required by hierMenus
   */
  function to_arrMenus($menu_name)
    {
      if ( !$this->hasChildren() )    return "";

      $js_menu = $menu_name." = new Array(\n";
      $nrCh = $this->nrChildren();
      for ($i=0; $i < $nrCh-1; $i++)
        {
          $ch = $this->children[$i];
          $js_menu .= "\t\"" . $ch->description . "\", \"" . $ch->action."\", "
            . ($ch->hasChildren() ? "1" : "0") . ",\n";
        }
      //last child
      $ch = $this->children[$i];
      $js_menu .= "\t\"" . $ch->description . "\", \"" . $ch->action."\", "
        . ($ch->hasChildren() ? "1" : "0") . "\n";      //without a comma
      $js_menu .= ");\n\n";
      $js_menu .= $this->children_to_arrMenus($menu_name."_");

      return $js_menu;
    }

  /**
   * transforms all the children to JavaScript code
   * and returns it as a string, used by to_arrMenus() etc.
   */
  function children_to_arrMenus($menu_name)
    {
      for ($i=0; $i < $this->nrChildren(); $i++)
        {
          $ch = &$this->children[$i];
          $ch_menu_name = $menu_name . ($i + 1);
          $js_menu .= $ch->to_arrMenus($ch_menu_name);
        }
      return $js_menu;
    }
}
?>
