<?php
/*
Copyright 2001,2002,2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

This file is part of phpWebApp.

phpWebApp is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

phpWebApp is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with phpWebApp; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  
*/


/**
 * @package     boxes
 * @subpackage  editMenus
 */
class editMenus extends WebObject
{
  function init()
    {
      global $session;
      $session->Vars["menu_data_path"] = EDITMENUS_PATH."sample_menu/menu_data/";
    }

  function eventHandler($event)
    {                   
      switch ($event->name)
        {
        case "moveUp":
        case "moveDown":
        case "update":
        case "delete":
        case "addBefore":
        case "addAfter":
        case "addChildren":
          include EDITMENUS_PATH."fun.editMenus.php";
          global $menus;
          editMenus_buildMenus();       
          $id = $event->args["menu_id"];
          $menus->change($id, "editMenus_".$event->name);
          editMenus_rewriteFiles();
          break;
        }
    }

  function onRender()
    {           
      global $session, $menus;
        
      if ( !isset($menus) )     $this->buildMenus();
      $menus->setEditAction();
        
      WebApp::addVar("MENUBAR", $menus->to_HTML_table() );
      WebApp::addVar("EDIT_ARRMENUS", $menus->to_arrMenus());
    }

  /** builds the global variable $menus */
  function buildMenus()
    {
      global $session, $menus;
        
      include EDITMENUS_PATH."class.Menus.php";
        
      $menu_path = $session->Vars["menu_data_path"];
      $menu_xml_file = $menu_path."menu_data.xml";
        
      /* 
       //This works only when the PHP is configured with DOM XML
         $menus = new Menus("Menus");
         $menus->read_xml($menu_xml_file);
      */
        
      //Uses the XML extention of PHP, requires PHP4
      include EDITMENUS_PATH."class.XMLMenus.php";
      $xmlMenus = new XMLMenus($menu_xml_file);
      $menus = $xmlMenus->getMenus();
    }
}
?>