<?php
/*
Copyright 2001,2002,2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

This file is part of phpWebApp.

phpWebApp is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

phpWebApp is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with phpWebApp; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  
*/


/**
 * Used for mesuring the execution time of
 * SQL queries and other processes or procedures.
 */
class Timer
{
  /** Table that keeps the time of execution */
  var $info;

  function Timer()
    {
      $this->info = array();
    }

  function Start($processID, $comment)
    {
      if (!EXECUTION_TIME_INFO) return;

      $this->info[$processID]["comment"] = $comment;
      $this->info[$processID]["startTime"] = microtime();
    }

  function Stop($processID)
    {
      if (!EXECUTION_TIME_INFO) return;

      $this->info[$processID]["endTime"] = microtime();
    }

  function GetTime($processID)
    {
      if (!EXECUTION_TIME_INFO) return;

      $startTime = $this->info[$processID]["startTime"];
      list($usec1, $sec1) = explode(" ", $startTime);

      $endTime = $this->info[$processID]["endTime"];
      list($usec2, $sec2) = explode(" ", $endTime);

      $micro_sec = ($sec2 - $sec1)*1000000 + ($usec2 - $usec1);
      return $micro_sec / 1000; //return milisecs
    }

  function toHtmlTable()
    {
      if (!EXECUTION_TIME_INFO) return;

      $html = $this->JSTimer_toHtmlTable();
      $html .= "
<table bgcolor='#aaaaaa' border='0' cellspacing='1' cellpadding='2'>
  <tr>
    <td bgcolor='#eeeeff' colspan='3'>
      &nbsp; Execution Times of Queries and PHP Functions
    </td>
  </tr>
  <tr>
    <td bgcolor='#eeeeee' nowrap='true'> Process ID </td>
    <td bgcolor='#eeeeee' nowrap='true'> Execution Time (msec) </td>
    <td bgcolor='#eeeeee' nowrap='true'> Comment </td>
  </tr>";

      while ( list($processID, $timeInfo) = each($this->info) )
        {
          $comment = $timeInfo["comment"];
          $executionTime = $this->GetTime($processID);
          $html .= "
  <tr>
    <td bgcolor='#f9f9f9'> $processID </td>
    <td bgcolor='#f9f9ff'> $executionTime </td>
    <td bgcolor='#f9f9f9'><xmp>$comment</xmp></td>
  </tr>";
        }
      $html .= "</table>";

      return $html;
    }

  function JSTimer()
    {
      if (!EXECUTION_TIME_INFO) return "";

      $timer_path = WebApp::to_url(TIMER_PATH);
      $js_code = "
  <script language='JavaScript' src='".$timer_path."class.Timer.js'></script>
  <script language='JavaScript'>
    var timer = new Timer();
    var comment = 'Time that spends the web-page to be transfered and loaded in browser'; 
    timer.Start('web-page', comment);
  </script>
";
      return $js_code;
    }

  function JSTimer_toHtmlTable()
    {
      $js_code = "
  <script language='JavaScript'>
    var timerHtmlTable;
    timer.Stop('web-page');
    timerHtmlTable = timer.toHtmlTable();
    document.write(timerHtmlTable);
  </script>
";
      return $js_code;
    }
}
?>