-- MySQL dump 8.22
--
-- Server version	3.23.54

--
-- Create the database top10_db
--

CREATE DATABASE IF NOT EXISTS top10_db;
USE top10_db;

--
-- Table structure for table 'categories'
--

DROP TABLE IF EXISTS categories;
CREATE TABLE categories (
  category varchar(50) NOT NULL default ''
) TYPE=MyISAM;

--
-- Dumping data for table 'categories'
--

INSERT INTO categories (category) VALUES ('web application framework'),('content managment system'),('document managment system'),('groupware'),('wiki');

--
-- Table structure for table 'comments'
--

DROP TABLE IF EXISTS comments;
CREATE TABLE comments (
  comment_id int(10) unsigned NOT NULL auto_increment,
  proj_id varchar(100) NOT NULL default '',
  username varchar(30) NOT NULL default '',
  title varchar(255) NOT NULL default '',
  comment text NOT NULL,
  date date NOT NULL default '0000-00-00',
  ip varchar(20) NOT NULL default '',
  PRIMARY KEY  (comment_id)
) TYPE=MyISAM;


--
-- Table structure for table 'languages'
--

DROP TABLE IF EXISTS languages;
CREATE TABLE languages (
  prog_lang varchar(30) NOT NULL default ''
) TYPE=MyISAM;

--
-- Dumping data for table 'languages'
--


INSERT INTO languages (prog_lang) VALUES ('PHP'),('Perl'),('JSP'),('Java');

--
-- Table structure for table 'licenses'
--

DROP TABLE IF EXISTS licenses;
CREATE TABLE licenses (
  license varchar(50) NOT NULL default ''
) TYPE=MyISAM;

--
-- Dumping data for table 'licenses'
--


INSERT INTO licenses (license) VALUES ('GPL'),('LGPL');

--
-- Table structure for table 'preference_list'
--

DROP TABLE IF EXISTS preference_list;
CREATE TABLE preference_list (
  proj_id varchar(100) NOT NULL default '',
  username varchar(30) NOT NULL default '',
  position smallint(4) NOT NULL default '0',
  PRIMARY KEY  (proj_id,username)
) TYPE=MyISAM;

--
-- Table structure for table 'proj_list'
--

DROP TABLE IF EXISTS proj_list;
CREATE TABLE proj_list (
  proj_id varchar(100) NOT NULL default '',
  proj_name varchar(100) NOT NULL default '',
  proj_descr text NOT NULL,
  category varchar(100) NOT NULL default '',
  status varchar(10) NOT NULL default '',
  license varchar(100) NOT NULL default '',
  prog_lang varchar(100) NOT NULL default '',
  register_date date default NULL,
  group_id varchar(10) NOT NULL default '',
  points int(11) NOT NULL default '0',
  nr_comments int(11) NOT NULL default '0',
  PRIMARY KEY  (proj_id)
) TYPE=MyISAM;

--
-- Table structure for table 'proj_members'
--

DROP TABLE IF EXISTS proj_members;
CREATE TABLE proj_members (
  proj_id varchar(100) NOT NULL default '',
  username varchar(30) NOT NULL default '',
  PRIMARY KEY  (proj_id,username)
) TYPE=MyISAM;

--
-- Table structure for table 'requests'
--

DROP TABLE IF EXISTS requests;
CREATE TABLE requests (
  request_id varchar(50) NOT NULL default '',
  time timestamp(14) NOT NULL,
  username varchar(30) NOT NULL default '',
  ip varchar(20) NOT NULL default '',
  type varchar(30) NOT NULL default '',
  data varchar(255) NOT NULL default '',
  status varchar(10) NOT NULL default '',
  PRIMARY KEY  (request_id)
) TYPE=MyISAM;

