<?php
/*
This file is part of phpWebApp,  which is a framework for building web
application based on relational databases.

Copyright 2001,2002,2003,2004 Dashamir Hoxha, dashohoxha@users.sf.net

phpWebApp is free  software; you can redistribute it  and/or modify it
under the terms of the GNU  General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

phpWebApp  is distributed  in the  hope that  it will  be  useful, but
WITHOUT   ANY  WARRANTY;   without  even   the  implied   warranty  of
MERCHANTABILITY  or FITNESS  FOR A  PARTICULAR PURPOSE.   See  the GNU
General Public License for more details.

You  should have received  a copy  of the  GNU General  Public License
along with phpWebApp;  if not, write to the  Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

include_once DB_PATH."class.Connection.php";

/**
 * This is the MySQL implementation of the interface Connection.
 * @package database
 */
class MySQLCnn extends Connection
{
  /**
   * Opens a connection using the given parameters.
   * If no parameters are given, then uses as default values
   * the constants declared in 'config/const.DB.php'.
   */
  function MySQLCnn($host =DBHOST, $user =DBUSER, 
                    $passw =DBPASS, $db_name =DBNAME)
  {
    $this->cnn = mysql_pconnect($host, $user, $passw);
    mysql_select_db($db_name) or die("unable to select db");
  }

  /**
   * MySQL specific function that executes the query
   * and returns a two-dimentional array, or a boolean value
   */
  function exec_query($query)
  {
    $result = mysql_query($query, $this->cnn);
    $this->show_error($query);
    if ( ereg("Resource", $result) )
      {
        //the query was a 'select' and has returned some records,
        //convert the results to a two dimentional table
        $table = $this->result2table($result);
        return $table;
      }
    else 
      {
        //the query was a command (insert, delete, update, etc.)
        //and it has returned TRUE or FALSE indicating success or failure
        return $result;
      }
  }

  /** Convert the mysql $result to a two-dimentional table. */
  function result2table(&$result)
  {                
    $arr_result = array();
    $i = 0;
    while ( $row = mysql_fetch_array($result, MYSQL_ASSOC) )
      {
        while ( list($fld_name, $fld_value) = each($row) )
          {
            if (!isset($fld_value))  $fld_value = NULL_VALUE;
            $arr_result[$i][$fld_name] = $fld_value;
          }
        $i++; //next row
      }
    mysql_free_result($result);

    return $arr_result;
  }
        
  function show_error($query ='')
  {
    if (mysql_errno()==0)     return;         //no error
    if (mysql_errno()==1062)  return;         //ignore this error
    if (mysql_errno()==1136)  return;         //ignore this error

    $err_msg = mysql_errno() . ": " . mysql_error(); 
    $err_msg = htmlentities($err_msg);
    $query = htmlentities($query);

    print "
<span class='db_error'>
<strong>MySQL Error:</strong>$err_msg
<br/>
<strong>Query:</strong>$query</span>
";
  }
}
?>