<?php
/*
This file is part of phpWebApp,  which is a framework for building web
application based on relational databases.

Copyright 2001,2002,2003,2004 Dashamir Hoxha, dashohoxha@users.sf.net

phpWebApp is free  software; you can redistribute it  and/or modify it
under the terms of the GNU  General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

phpWebApp  is distributed  in the  hope that  it will  be  useful, but
WITHOUT   ANY  WARRANTY;   without  even   the  implied   warranty  of
MERCHANTABILITY  or FITNESS  FOR A  PARTICULAR PURPOSE.   See  the GNU
General Public License for more details.

You  should have received  a copy  of the  GNU General  Public License
along with phpWebApp;  if not, write to the  Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


/**
 * @package database
 */

if (USES_DB)
{
  switch (DB_TYPE)
    {
    case "MySQL":
      $CnnType = "MySQLCnn";
      break;
    case "Oracle":
    case "ODBC":
    case "ProgreSQL":
    case "SQLServer":
    default:
      print "Sorry, DB_TYPE='".DB_TYPE."' is not implemented yet.<br />\n";
      break;
    }
  include_once DB_PATH."class.$CnnType.php";

  /**
   * Create a default connection for the application. Parameters 
   * of this connection are specified in 'config/const.DB.php'.
   * This connection will be used for each interaction with a DB,
   * if no other connection is specified. The application, however,
   * can create and use other connections as well, or override this one.
   */
  include_once CONFIG_PATH."const.DB.php";
  $cnn = new $CnnType;  
}

include_once DB_PATH."class.Recordset.php";
include_once DB_PATH."class.StaticRS.php";
include_once DB_PATH."class.EditableRS.php";
include_once DB_PATH."class.PagedRS.php";
include_once DB_PATH."class.TableRS.php";
?>
