<?php
/*
This file is part of phpWebApp,  which is a framework for building web
application based on relational databases.

Copyright 2001,2002,2003,2004 Dashamir Hoxha, dashohoxha@users.sf.net

phpWebApp is free  software; you can redistribute it  and/or modify it
under the terms of the GNU  General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

phpWebApp  is distributed  in the  hope that  it will  be  useful, but
WITHOUT   ANY  WARRANTY;   without  even   the  implied   warranty  of
MERCHANTABILITY  or FITNESS  FOR A  PARTICULAR PURPOSE.   See  the GNU
General Public License for more details.

You  should have received  a copy  of the  GNU General  Public License
along with phpWebApp;  if not, write to the  Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


/**
 * Includes the JS L10n messages in the HTML page.
 * @package l10n
 */
class wbJSL10n extends WebObject
{
  function onRender()
  {
    global $webPage;  

    $arr_msg = array();
    while ( list($msgid, $msgstr) = each($webPage->js_i18n_messages) )
      {
        //remove an extra slash and newline
        $msgid = str_replace("\\\n", "", $msgid);

        //replace newlines by '\n' (otherwise JS error will occur)
        $msgid = str_replace("\n", "\\n", $msgid);
        $msgstr = str_replace("\n", "\\n", $msgstr);

        //add the translation in the list of messages
        $arr_msg[] = "l10n.addMsg(\"$msgid\", \"$msgstr\");";
      }

    //add the template variable {{JS_L10N_MESSAGES}} 
    WebApp::addVar("JS_L10N_MESSAGES", implode($arr_msg, "\n  "));
  }
}
?>