<?php
/*
This file is part of phpWebApp,  which is a framework for building web
application based on relational databases.

Copyright 2001,2002,2003,2004 Dashamir Hoxha, dashohoxha@users.sf.net

phpWebApp is free  software; you can redistribute it  and/or modify it
under the terms of the GNU  General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

phpWebApp  is distributed  in the  hope that  it will  be  useful, but
WITHOUT   ANY  WARRANTY;   without  even   the  implied   warranty  of
MERCHANTABILITY  or FITNESS  FOR A  PARTICULAR PURPOSE.   See  the GNU
General Public License for more details.

You  should have received  a copy  of the  GNU General  Public License
along with phpWebApp;  if not, write to the  Free Software Foundation,
Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


/**
 * @package     webobjects
 * @subpackage  formWebObj
 */
class formWebObj extends WebObject
{
  function afterParse()
  {
    global $webPage;

    //prepend js code to the content of this template
    $form_url = WebApp::to_url(FORM_PATH);
    $js_code = "<script type=\"text/javascript\" language=\"javascript\" "
      . "src=\"".$form_url."formWebObj.js\"></script>\n";
    $webPage->append_to_head($js_code);

    //append js code to the content of this template
    global $formData;  //form data comes with transmitVar() as a global var
    if (isset($formData))
      {
        $form_name = $this->get_form_name();
        $js_code = "
<script type=\"text/javascript\" language=\"javascript\">
//<![CDATA[
  var form = document.$form_name;
  var formData = '$formData';
  setFormData(form, formData);
//]]>
</script>
";
        $this->contents .= $js_code;
      }
  }

  /** finds and returns the name of the form in this template */
  function get_form_name()
  {
    $pattern = '/<form[^>]*name=("|\')([^\\1]+)\\1/';
    preg_match($pattern, $this->contents, $matches);
    $form_name = $matches[2];
    return $form_name;
  }
}
?>