<?php
/*
This file  is part of Top10.   Top10 is a web  application for ranking
and evaluating web application projects at SourceForge.

Copyright 2003 Dashamir Hoxha, dashohoxha@users.sourceforge.net

Top10 is free software; you can redistribute it and/or modify it under
the terms of  the GNU General Public License as  published by the Free
Software  Foundation; either  version 2  of the  License, or  (at your
option) any later version.

Top10 is distributed  in the hope that it will  be useful, but WITHOUT
ANY WARRANTY; without even  the implied warranty of MERCHANTABILITY or
FITNESS FOR A  PARTICULAR PURPOSE. See the GNU  General Public License
for more details.

You  should have received  a copy  of the  GNU General  Public License
along with Top10; if not, write to the Free Software Foundation, Inc.,
59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

class proj_details extends WebObject
{
  function init()
    {
      $this->addSVar("proj_id", UNDEFINED);
    }

  function on_set_project($event_args)
    {
      $proj_id = $event_args["proj_id"];
      $this->setSVar("proj_id", $proj_id);
    }

  function onRender()
    {
      $this->add_project_data();
    }

  function add_project_data()
    {
      $proj_id = $this->getSVar("proj_id");
      if ($proj_id==UNDEFINED)
        {
          WebApp::addVar("proj_id", "UNDEFINED");
          return;
        }

      $rs = WebApp::openRS("get_project_data", compact("proj_id"));
      $proj_data = $rs->Fields();
      WebApp::addVars($proj_data);      
    }
}
?>