#!/bin/sh
# 
# Photo Image Print System
# Copyright (C) 2001-2004 EPSON KOWA Corporation.
# Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
# 
#  This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 

if test -z $DESTDIR; then
    DESTDIR=
fi

PRINTER_MODEL_LOW=sc84_83s
PRINTER_MODEL=$(echo $PRINTER_MODEL_LOW | tr [:lower:] [:upper:])

PIPS_BIN_NAME=pips-sc84_83s-cups

PREFIX=$DESTDIR/usr
ETCDIR=$DESTDIR/etc
KOWADIR=$PREFIX/local/EPKowa
PKGDATADIR=$KOWADIR/$PRINTER_MODEL

MKDIR="mkdir -p"


if [ -x /usr/sbin/printconf-backend ]; then
    PRINTCAP=$DESTDIR/etc/printcap.local
else
    PRINTCAP=$DESTDIR/etc/printcap
fi


case "$1" in
    install)
	KEY=`grep 35586 < /etc/services`
	if [ -z "$KEY" ]; then
	    if [ -s $ETCDIR/services ]; then
		cp $ETCDIR/services $ETCDIR/services.bak
	    fi
	    cat <<EOF >>$ETCDIR/services
# written for $PIPS_BIN_NAME
cbtd     35586/tcp
# $PIPS_BIN_NAME  end
EOF
	    
	    echo "Install Message > Described entry of $PRINTER_MODEL in services."
	    echo "Install Message > Backup file is /etc/services.bak."
	fi
	
#
# rcfile install
#
	DESTDIR=$DESTDIR $PKGDATADIR/inst-rc_d.sh install
	
	echo "Install Message > Start /usr/local/EPKowa/$PRINTER_MODEL/setup to change setup."
	
# printer reset
	DIST=`$PKGDATADIR/inst-rc_d.sh checkdist`
	$PKGDATADIR/rc.d/ekpd.$DIST restart 2>&1 1>/dev/null
	;;

    deinstall)
	if [ -s $DESTDIR/etc/services ]; then
	    KEY=`grep "\# written for $PIPS_BIN_NAME" /etc/services`
	    if [ -n "$KEY" ]; then
		mv $DESTDIR/etc/services $DESTDIR/etc/services.bak
		sed -e "/# written for $PIPS_BIN_NAME/,/# $PIPS_BIN_NAME  end/d" < $DESTDIR/etc/services.bak > $DESTDIR/etc/services
	    fi
	fi

	$PKGDATADIR/inst-rc_d.sh deinstall
	;;
    *)
	echo "Usage: install_post.sh { install | deinstall }" >&2
	exit 1
	;;
esac


