/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#if USE_GTK

#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "xMode.h"
#include "ekpcom.h"
#include "getstat.h"
#include "setup.h"

typedef struct _IO_SIGDATA
{
	GtkWidget *filewin;
	GtkWidget *entry;
} IO_SIGDATA;

extern void *options[EX_N_OPT];
extern void *opt_address[EX_N_OPT];
extern char *input_file;
extern char *output_file;
extern int output_type;
extern UTIL_PACK pips_util_pack;
extern GtkWidget *margin_frame_;

static GtkWidget* commonPixmapLoad(char*);

static RADIO_PACK* radioPackAdd(int);
static void radioPackChengeValue(GtkWidget*, RADIO_PACK*);

static CHECK_PACK* checkPackAdd(int);
static void checkPackSetSensitive(CHECK_PACK*, int);
static void checkPackChengeValue(GtkWidget*, CHECK_PACK*);

static SELECT_PACK* selectPackAdd(int);
static void selectPackSetSensitive(SELECT_PACK*, char*[]);
static void selectPackVisibility(SELECT_PACK*, int);
static void selectPackChengeValue(GtkWidget*, SELECT_PACK*);

static SPIN_PACK* spinPackAdd(int);
static void spinPackSetSensitive (SPIN_PACK *, int);
static void spinPackChengeValue(GtkAdjustment*, SPIN_PACK*);

static ADJUSTMENT_PACK* adjustmentPackAdd(int);
static void adjustmentPackSetSensitive(ADJUSTMENT_PACK*, int);
static void adjustmentPackChengeValue(GtkAdjustment*, ADJUSTMENT_PACK*);
static void adjustmentPackChengeEntry(GtkWidget*, ADJUSTMENT_PACK*);
static void adjustmentPackCheckEntry(GtkWidget*, GdkEvent*, ADJUSTMENT_PACK*);

static void ioOutputTypeSet(GtkWidget*, gpointer);
static GtkWidget* ioPackButton(GtkWidget*);
static void ioPackFileSelection(GtkWidget*, GtkWidget*);
static void ioPackOkSel(GtkWidget*, IO_SIGDATA*);
static void ioPackCanSel(GtkWidget*, IO_SIGDATA*);
static void ioPackChengeValue(GtkEntry*, char*);

#ifdef CONV_VERSION2
static void margin_default_set (GtkWidget*, void*);
static void margin_abjset (void);
static void margin_updata (int, long, long);

#endif /* CONV_VERSION2 */

/* ================================================== */
/*           common functions */
/* ================================================== */
static GtkWidget*
commonPixmapLoad (char *map)
{
	GtkWidget *pixmap = NULL;
	//=-=-=-=-=-=-=-=-=-=-=-=-=-=
	//    under construction
	//=-=-=-=-=-=-=-=-=-=-=-=-=-=
	return pixmap;
}

char*
commonLabelCall (int id, OPTION_DATA *data)
{
	int i;
	char *title = NULL;

	if (data == NULL)
	{
		for (i = 0; opt_all[i].id != END_ARRAY; i++)
		{
			if (opt_all[i].id == id)
				title = opt_all[i].x_name;
		}
	}
	else
	{
		title = data->x_name;
	}
  
	if (title)
		return (char*)_(title);
  
	return NULL;
}

void
commonSetOptionsSensitive (void)
{
	int i, j, count, offset;
	int flag[ENTRY_MAX];
	char *new_entry[ENTRY_MAX];
	const short *mode;
	SEP_INIT_PARAM *sepip_lite;
	OPTION_DATA *data;
	SELECT_PACK *sp;
	int bin_type;

	/* å */
	int mw_type;
	int once;
	
	sepip_lite = (SEP_INIT_PARAM *)malloc (sizeof (SEP_INIT_PARAM));

	count = 0;
	sp = (SELECT_PACK *)opt_address[P_COLOR_MODE];
	if (strcmp ((char *)options[P_INK], "MONO"))
	{ /* Color */
		mode = pModeCol;
		flag[0] = TRUE;
		gtk_widget_show (sp->hbox);
	}
	else
	{ /* mono */
		mode = pModeMono;
		flag[0] = FALSE;
		gtk_widget_hide (sp->hbox);
	}
  
  
	if (strcmp ((char *)options[P_COLOR_MODE], "NONE")) flag[1] = TRUE;
	else flag[1] = FALSE;
	adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_BRIGHTNESS], flag[1]);
	adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_CONTRAST], flag[1]);

	if (flag[1])
	{
		adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_SATURATION], flag[0]);
		adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_STRENGTH_CYAN], flag[0]);
		adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_STRENGTH_MAGENTA], flag[0]);
		adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_STRENGTH_YELLOW], flag[0]);
	}
	else
	{
		adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_SATURATION], FALSE);
		adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_STRENGTH_CYAN], FALSE);
		adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_STRENGTH_MAGENTA], FALSE);
		adjustmentPackSetSensitive ((ADJUSTMENT_PACK *)opt_address[P_STRENGTH_YELLOW], FALSE);
	}


	/* ѥ᡼,Υߡ */
	sepip_lite->src_resolution.x = sepip_lite->halftone_type
		= sepip_lite->high_speed = sepip_lite->qlevel
		= sepip_lite->media_type = sepip_lite->mw_type
		= sepip_lite->bin_id = sepip_lite->inkset = -1;

	/* make new media type entry */
#if defined(USE_AUTO_TRIM_4) || defined(INK_CHANGE_SYSTEM)
	{
#ifdef USE_AUTO_TRIM_4
		sepip_lite->bin_id = getValueOfDatabases (P_BIN, (char *)options[P_BIN]);
		sepip_lite->prt_format = getValueOfDatabases (P_INK, (char *)options[P_INK]);
#endif /* USE_AUTO_TRIM_4 */
#ifdef INK_CHANGE_SYSTEM
		sepip_lite->inkset = getValueOfDatabases (P_INKSET, (char *)options[P_INKSET]);
#endif /* INK_CHANGE_SYSTEM */

		data = opt_all[P_MEDIA_TYPE].data;
		for (i = 0; data[i].value != END_ARRAY; i++)
			flag[i] = FALSE;
		
		for (i = 0; mode[i * MODE_ITEM] >= 0; i++)
		{
			if (!printModeCheck (mode, i, sepip_lite))
			{
				for (j = 0; data[j].value != END_ARRAY; j++)
				{
					offset = i * MODE_ITEM;
					if (data[j].value == mode[offset + MOFS_MEDIA])
					{
						flag[j] = TRUE;
					}
				}
			}
		}
	
		count = 0;
		for (i = 0; data[i].value != END_ARRAY; i++)
		{
			if (flag[i] == TRUE)
			{
				new_entry[count++] = data[i].rsc_name;
			}
#if (PM940C) || (PM980C)
			else{
				if( data[i].value & SILENT_MASK ){
					new_entry[count++] = data[i].rsc_name;
				}
			}
#endif
		}
		new_entry[count] = NULL;
		selectPackSetSensitive ((SELECT_PACK *)opt_address[P_MEDIA_TYPE], new_entry);
	}
#endif /* define(USE_AUTO_TRIM_4) || define(INK_CHANGE_SYSTEM) */

	/* make new resolution entry */
	sepip_lite->media_type = getValueOfDatabases (P_MEDIA_TYPE, (char *)options[P_MEDIA_TYPE]);
	data = opt_all[P_RESOLUTION].data;

	for (i = 0; data[i].value != END_ARRAY; i++)
		flag[i] = FALSE;
	
	count = 0;
	for (i = 0; mode[i * MODE_ITEM] >= 0; i++)
	{
		if (!printModeCheck (mode, i, sepip_lite))
		{
			for (j = 0; data[j].value != END_ARRAY; j++)
			{
				offset = i * MODE_ITEM;
#ifdef USE_360_DRAFT
				if (mode[offset + MOFS_INPUT] & (int)ldexp (1.0, j + 1))
#else
				if (mode[offset + MOFS_INPUT] & (int)ldexp (1.0, j))
#endif /* USE_360_DRAFT */
				{
					flag[j] = TRUE;
				}
			}
		}
	}
	count = 0;
	for (i = 0; data[i].value != END_ARRAY; i++)
	{
		if (flag[i] == TRUE)
		{
			new_entry[count++] = data[i].rsc_name;
		}
	}
	new_entry[count] = NULL;
	selectPackSetSensitive ((SELECT_PACK *)opt_address[P_RESOLUTION], new_entry);


	// make new quality level entry
	sepip_lite->src_resolution.x = getValueOfDatabases (P_RESOLUTION, (char *)options[P_RESOLUTION]);
	data = opt_all[P_QUALITY_LEVEL].data;

	for (i = 0; data[i].value != END_ARRAY; i++) flag[i] = FALSE;
	for (i = 0; mode[i * MODE_ITEM] >= 0; i++)
	{
		if (!printModeCheck (mode, i, sepip_lite))
		{
			unsigned int bit = mode[i * MODE_ITEM + MOFS_QUALITY];
			switch (sepip_lite->src_resolution.x)
			{

			case 120:
			case 180: flag[0] = TRUE;
     
			case 720: bit = bit >> 4;
			case 360: bit = bit >> 4;

#if USE_RESOLUTION_240
			case 240: bit = bit >> 4;
#endif /* USE_RESOLUTION_240 */

			}
			bit &= 0x0f;
			for (j = 0; data[j].value != END_ARRAY; j++)
			{
				if (bit == data[j].value) flag[j] = TRUE;
			}
		}
	}
	count = 0;
	for (i = 0; data[i].value != END_ARRAY; i++)
		if (flag[i] == TRUE)
			new_entry[count++] = data[i].rsc_name;
	new_entry[count] = NULL;
	selectPackSetSensitive ((SELECT_PACK *)opt_address[P_QUALITY_LEVEL], new_entry);
	selectPackVisibility ((SELECT_PACK *)opt_address[P_QUALITY_LEVEL], i - 1);


	/* check micro weave sensitive */
	data = opt_all[P_QUALITY_LEVEL].data;
	for (i = 0; data[i].value != END_ARRAY; i++)
		flag[i] = FALSE;
	sepip_lite->qlevel = getValueOfDatabases (P_QUALITY_LEVEL, (char *)options[P_QUALITY_LEVEL]);

	once = FALSE;
	mw_type = 0;
	for (i = 0; mode[i * MODE_ITEM] >= 0; i++)
	{
		if (!printModeCheck (mode, i, sepip_lite))
		{
			
			offset = i * MODE_ITEM;
			if( once ){
				/* Same mode again */
	                        if( mode[offset + MOFS_MICRO_WEAVE] != mw_type ){
					mw_type = 2;
					break;
				}
			}else{
	                         mw_type = mode[offset + MOFS_MICRO_WEAVE];
				 if( mw_type == 2 ){
					/* On/Off */
				 	break;
			         }
				 once = TRUE;
		 	}
		}
	}

	checkPackSetSensitive ((CHECK_PACK *)opt_address[P_MICRO_WEAVE], mw_type );

	/* check high speed sensitive */
	sepip_lite->mw_type = getValueOfDatabases (P_MICRO_WEAVE, (char *)options[P_MICRO_WEAVE]);

	for (i = 0; mode[i * MODE_ITEM] >= 0; i++)
	{
		if (!printModeCheck (mode, i, sepip_lite))
		{
			offset = i * MODE_ITEM;
			checkPackSetSensitive ((CHECK_PACK *)opt_address[P_HIGH_SPEED], mode[offset + MOFS_HIGH_SPEED]);
			goto OUT_HS;
		}
	}
 OUT_HS:
  
  
	/* make halftonetype entry */
	data = opt_all[P_HALF_TONE].data;
	for (i = 0; data[i].value != END_ARRAY; i++) flag[i] = FALSE;

	for (i = 0; mode[i * MODE_ITEM] >= 0; i++)
	{
		if (!printModeCheck(mode, i, sepip_lite))
		{
			for (j = 0; data[j].value != END_ARRAY; j++)
			{
				offset = i * MODE_ITEM;
				if (mode[offset + MOFS_HALFTONE] & (int)ldexp(1.0, j)) flag[j] = TRUE;
			}
			goto OUT_HT;
		}
	}
 OUT_HT:
  
	count = 0;
	for (i = 0; data[i].value != END_ARRAY; i++)
		if (flag[i] == TRUE)
			new_entry[count++] = data[i].rsc_name;
	new_entry[count] = NULL;
	selectPackSetSensitive ((SELECT_PACK *)opt_address[P_HALF_TONE], new_entry);
  

	bin_type = getValueOfDatabases (P_BIN, (char *)options[P_BIN]);

	/* Media size */
	{
		char **msentry;
#if (PM940C) || (PM980C)		
		char **msentrySilent;
#endif
		switch (bin_type)
		{
		case PIPS_BIN_AUTO: msentry = mediaSizeEntry; break;
		case PIPS_BIN_USER: msentry = mediaSizeEntry_R; break;
#ifndef PM820_3300C
		case PIPS_BIN_TRIMBANNER: msentry = mediaSizeEntry_TR; break;
#else
		case PIPS_BIN_TB_PM3300C: msentry = mediaSizeEntry_TR_PM3300C; break;
		case PIPS_BIN_TB_PM820C: msentry = mediaSizeEntry_TR_PM820C; break;
		case PIPS_BIN_AUTO_TRIM: msentry = mediaSizeEntry_TA; break;
#endif /* PM820_3300C */
#ifdef USE_AUTO_TRIM_4
		case PIPS_BIN_AUTO_TRIM_4: msentry = mediaSizeEntry_NMA; break;
#endif
#if (PMG800)
		case PIPS_BIN_MANUAL: msentry = mediaSizeEntry_M; break;
		case PIPS_BIN_MANUAL_TRIM: msentry = mediaSizeEntry_TM; break;
#endif

		default: abort ();
		}

#if (PM940C) || (PM980C)
		/* alloc work buffer, 25 means no. of paper */ 
		msentrySilent = (char **)malloc(sizeof(char *) * 25 );
		if( !msentrySilent ){
			/* no memory */
			abort();
		}
				 
		/* resetting mediaSizeEntry for Silent Feed */
		if( !strcmp( "PLAIN_SILENT", options[P_MEDIA_TYPE] )
		||  !strcmp( "EPP_SILENT", options[P_MEDIA_TYPE] ) ){
			int ok,i,j,k;
			k= 0;
			for( i=0; msentry[i] ; i++ ){
				ok=1;
				for( j=0; mediaSizeReject[j];j++ ){
					if( !strcmp(mediaSizeReject[j],msentry[i]) ){
						ok = 0;
						break;
					}
				}
				if( ok ){
					msentrySilent[k++] = msentry[i];
				}
			}
			msentrySilent[k] = (char *)0;
			msentry = msentrySilent;
		}
#endif
		
		selectPackSetSensitive ((SELECT_PACK *)opt_address[P_MEDIA_SIZE], msentry);

#if  (PM940C) || (PM980C)
		/* clean up  */
		if( msentrySilent ) free( msentrySilent );
#endif
	}

	/* Auto cut */
	{
		data = opt_all[P_AUTO_CUT].data;

		new_entry[0] = data[0].rsc_name;

		if ((bin_type == PIPS_BIN_USER
		     || bin_type == PIPS_BIN_TRIMBANNER)
		    && sepip_lite->mw_type == PIPS_MW_ON
		    && autoCutEntry[1] != NULL)
		{
			new_entry[1] = data[1].rsc_name;

			if (bin_type == PIPS_BIN_TRIMBANNER)
			{
				new_entry[2] = data[2].rsc_name;
				new_entry[3] = NULL;
			}
			else
			{
				new_entry[2] = NULL;
			}
		}
		else
		{
			new_entry[1] = NULL;
		}
		selectPackSetSensitive ((SELECT_PACK *)opt_address[P_AUTO_CUT], new_entry);
	}


	free (sepip_lite);

#ifdef CONV_VERSION2
	margin_abjset ();
#endif /* CONV_VERSION2 */

	if ((char *)options[P_FIT_PAGE])
	{			/* ON */
		spinPackSetSensitive ((SPIN_PACK *)opt_address[P_SCALE], FALSE);
		gtk_widget_set_sensitive(margin_frame_, FALSE);
	}
	else
	{			/* OFF */
		spinPackSetSensitive ((SPIN_PACK *)opt_address[P_SCALE], TRUE);
		gtk_widget_set_sensitive(margin_frame_, TRUE);
	}
}


/* ================================================== */
/*           radio pack functions */
/* ================================================== */

static RADIO_PACK* radioPackAdd(int id)
{
	RADIO_PACK *rp;

	rp = (RADIO_PACK *)malloc(sizeof(RADIO_PACK));
	rp->id = id;
	rp->pixmap = NULL;
	rp->label = NULL;
	rp->group = NULL;

	opt_address[id] = rp;
	return rp;
}


static void radioPackChengeValue(GtkWidget *widget, RADIO_PACK *rp)
{
	GSList *node;
	GtkWidget *radio;
	int i, id;

	id = rp->id;
	for (i = 0; (node = g_slist_nth (rp->group, i)) != NULL; i++)
	{
		radio = (GtkWidget *)node->data;
		if (radio == widget)
		{
			options[id] = (void *)opt_all[id].data[i].rsc_name;
			break;
		}
	}
	commonSetOptionsSensitive ();
}

GtkWidget* radioPackNew(char *map, char *entry[], int id)
{
	GtkWidget *frame;
	GtkWidget *hbox;
	GtkWidget *pixmap=0;
	GtkWidget *radio;
	GSList *group;
	RADIO_PACK *rp;
	OPTION_DATA *data;
	int offset = 0;
	gpointer sig_id;

	rp = radioPackAdd(id);
	sig_id = opt_address[id];

	frame = gtk_frame_new (commonLabelCall(id, NULL));
	gtk_frame_set_shadow_type (GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);

	hbox = gtk_hbox_new (FALSE, GTK_BORDER);

	if (map) pixmap = commonPixmapLoad (map);
  
	for (offset = 0; entry[offset] != NULL; offset++);
	if ((data = databasesCall (CALL_FOR_RSC_NAME, id, (void*)entry[-- offset])) == NULL)
		return NULL;

	radio = gtk_radio_button_new_with_label (NULL, commonLabelCall(id, data));

	if (!strcmp (data->rsc_name, (char*)options[id]))
		gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radio), TRUE);
	else
		gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radio), FALSE);

	gtk_signal_connect (GTK_OBJECT(radio), "pressed",
			    GTK_SIGNAL_FUNC(radioPackChengeValue), sig_id);
	gtk_box_pack_start (GTK_BOX(hbox), radio, FALSE, FALSE, 0);
	gtk_widget_show (radio);

	group = gtk_radio_button_group (GTK_RADIO_BUTTON(radio));

	offset--;
	for (; offset >= 0; offset --)
	{
		if ((data = databasesCall (CALL_FOR_RSC_NAME, id, (void*)entry[offset])) == NULL)
			return NULL;

		radio = gtk_radio_button_new_with_label (group, commonLabelCall(id, data));

		if (!strcmp(data->rsc_name, (char*)options[id]))
			gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radio), TRUE);
		else
			gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(radio), FALSE);
		
		gtk_signal_connect (GTK_OBJECT(radio), "pressed",
				    GTK_SIGNAL_FUNC(radioPackChengeValue), sig_id);
		gtk_box_pack_start (GTK_BOX(hbox), radio, FALSE, FALSE, 0);
		gtk_widget_show (radio);

		group = gtk_radio_button_group (GTK_RADIO_BUTTON(radio));
	}
  
	gtk_container_add (GTK_CONTAINER(frame), hbox);
	gtk_widget_show (hbox);

	rp->id = id;
	if (map) rp->pixmap = pixmap;
	rp->group = group;
  
	gtk_container_set_border_width (GTK_CONTAINER (frame), GTK_BORDER);
	return frame;
}

/* ================================================== */
/*           check_pack functions */
/* ================================================== */

static CHECK_PACK* checkPackAdd(int id)
{
	CHECK_PACK *cp;

	cp = (CHECK_PACK *)malloc(sizeof(CHECK_PACK));
	cp->id = id;
	cp->id = 0;
	cp->pixmap = NULL;
	cp->check = NULL;

	opt_address[id] = cp;
	return cp;
}


static void checkPackSetSensitive(CHECK_PACK *cp, int flag)
{
	int aflag = FALSE;

	if(flag == 2) aflag = TRUE;
	if(cp->pixmap) gtk_widget_set_sensitive(cp->pixmap, TRUE);
	gtk_widget_set_sensitive(cp->check, aflag);

	if(flag != 2)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cp->check), flag);
	cp->flag = 1;
	gtk_signal_emit_by_name(GTK_OBJECT(cp->check), "toggled");
}


static void checkPackChengeValue(GtkWidget *widget, CHECK_PACK *cp)
{
	OPTION_DATA *optdata;
	int i, id;

	id = cp->id;
	if(GTK_TOGGLE_BUTTON(widget)->active){
		for(i = 0; opt_all[i].id != id; i++);
		optdata = databasesCall(CALL_FOR_X_NAME, id, (void*)opt_all[i].x_name);
		options[id] = (void *)optdata->rsc_name;
	}
	else{
		options[id] = NULL;
	}
	if(cp->flag == 0){
		commonSetOptionsSensitive();
	}
	cp->flag = 0;
}

GtkWidget* checkPackNew(char *map, int id)
{
	GtkWidget *hbox;
	GtkWidget *pixmap=0;
	GtkWidget *check;
	CHECK_PACK *cp;
	void *sig_id;
  
	cp = checkPackAdd(id);
	sig_id = opt_address[id];

	hbox = gtk_hbox_new(FALSE, GTK_BORDER);

	if(map){
		pixmap = commonPixmapLoad(map);
		gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, TRUE, 0);
	}

	check = gtk_check_button_new_with_label(commonLabelCall(id, NULL));
	gtk_widget_show(check);
	gtk_box_pack_start(GTK_BOX(hbox), check, TRUE, TRUE, 0);

	if(options[id] != NULL) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), TRUE);
	else gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(check), FALSE);

	gtk_signal_connect(GTK_OBJECT(check), "toggled", GTK_SIGNAL_FUNC(checkPackChengeValue), sig_id);

	cp->id = id;
	cp->flag = 0;
	if(map) cp->pixmap = pixmap;
	cp->check = check;
	return hbox;
}


/* ================================================== */
/*           select_pack functions */
/* ================================================== */

static SELECT_PACK* selectPackAdd(int id)
{
	SELECT_PACK *sp;

	sp = (SELECT_PACK *)malloc(sizeof(SELECT_PACK));
	sp->id = id;
	sp->pixmap = NULL;
	sp->label = NULL;
	sp->optmenu = NULL;
	sp->hbox = NULL;

	opt_address[id] = sp;
	return sp;
}


static void selectPackSetSensitive(SELECT_PACK *sp, char *entry[])
{
	GtkWidget *optmenu;
	GtkWidget *menu;
	GtkWidget *item;
	OPTION_DATA *data;
	int i, id, def;
	char *title;
	gpointer sig_id;

	id = sp->id;
	title = commonLabelCall(id, NULL);
	sig_id = opt_address[id];
	menu = gtk_menu_new();
	def = -1;
	for(i = 0; entry[i] != NULL; i++){
		data = databasesCall(CALL_FOR_RSC_NAME, id, (void*)entry[i]);
		item = gtk_menu_item_new_with_label(commonLabelCall(id, data));
		gtk_object_set_data(GTK_OBJECT(item), title, data);
		gtk_signal_connect(GTK_OBJECT(item), "activate",
				   GTK_SIGNAL_FUNC(selectPackChengeValue), sig_id);
		if(!strcmp(data->rsc_name, (char*)options[id])) def = i;
		gtk_menu_insert(GTK_MENU(menu), item, i);
		gtk_widget_show(item);
	}
	if(def == -1){
		options[id] = entry[0];
		def = 0;
	}
	gtk_menu_set_active(GTK_MENU(menu), def);
	optmenu = sp->optmenu;
	gtk_option_menu_remove_menu(GTK_OPTION_MENU(optmenu));
	gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), menu);
}


static void selectPackVisibility(SELECT_PACK *sp, int flag)
{
	if(sp == NULL) return;
	if(flag) gtk_widget_show(sp->hbox);
	else gtk_widget_hide(sp->hbox);
}
  

static void selectPackChengeValue(GtkWidget *widget, SELECT_PACK *sp)
{
	GtkWidget *label;
	OPTION_DATA *optdata;
	int id;

	id = sp->id;
	label = sp->label;
	optdata = (OPTION_DATA *)gtk_object_get_data(GTK_OBJECT(widget), GTK_LABEL(label)->label);
	options[id] = optdata->rsc_name;
	commonSetOptionsSensitive();

	/* set margin abjustment  -add Mon Aug 28 2000 sk */
	if (id == P_MEDIA_SIZE || id == P_BIN)
	{
		margin_default_set (NULL, NULL);
	}
}



GtkWidget* selectPackNew(char *map, char *entry[], int id)
{
	GtkWidget *hbox;
	GtkWidget *pixmap=0;
	GtkWidget *label;
	GtkWidget *optmenu;
	GtkWidget *menu;
	GtkWidget *item;
	SELECT_PACK *sp;
	OPTION_DATA *data;
	char *title;
	int i, def=0;
	gpointer sig_id;

	sp = selectPackAdd(id);
	sig_id = opt_address[id];

	hbox = gtk_hbox_new(FALSE, GTK_BORDER);

	if(map) pixmap = commonPixmapLoad(map);

	title = commonLabelCall(id, NULL);
	label = gtk_label_new(title);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);

	optmenu = gtk_option_menu_new();
	menu = gtk_menu_new();
	for(i = 0; entry[i] != NULL; i++){
		if((data = databasesCall(CALL_FOR_RSC_NAME, id, (void*)entry[i])) == NULL)
			return NULL;
		item = gtk_menu_item_new_with_label(commonLabelCall(id, data));
		gtk_object_set_data(GTK_OBJECT(item), title, data);
		if(!strcmp(data->rsc_name, (char*)options[id])) def = i;
		gtk_menu_insert(GTK_MENU(menu), item, i);
		gtk_widget_show(item);
		gtk_signal_connect(GTK_OBJECT(item), "activate",
				   GTK_SIGNAL_FUNC(selectPackChengeValue), sig_id);

	}
	gtk_menu_set_active(GTK_MENU(menu), def);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), menu);
	gtk_box_pack_start(GTK_BOX(hbox), optmenu, TRUE, TRUE, 0);
	gtk_widget_show(optmenu);
  
	if(map) sp->pixmap = pixmap;
	sp->label = label;
	sp->optmenu = optmenu;
	sp->hbox = hbox;
	return hbox;
}


/* ================================================== */
/*           spin_pack functions */
/* ================================================== */


static SPIN_PACK* spinPackAdd(int id)
{
	SPIN_PACK *spp;

	spp = (SPIN_PACK *)malloc(sizeof(SPIN_PACK));
	spp->id = id;
	spp->pixmap = NULL;
	spp->label = NULL;
	spp->adj = NULL;
	spp->spin = NULL;

	opt_address[id] = spp;
	return spp;
}


static void spinPackSetSensitive (SPIN_PACK *spp, int flag)
{
	if(spp->pixmap) gtk_widget_set_sensitive(spp->pixmap, flag);
	gtk_widget_set_sensitive(spp->label, flag);
	gtk_widget_set_sensitive(spp->spin, flag);
}

static void spinPackChengeValue(GtkAdjustment *adj, SPIN_PACK *spp)
{
	int id, *new_value;
  
	id = spp->id;
	new_value = (int *)options[id];
	*new_value = (int)adj->value;
}



GtkWidget* spinPackNew(char *map, int id, double param[])
{
	GtkWidget *hbox;
	GtkWidget *pixmap=0;
	GtkWidget *label;
	GtkObject *adj;
	GtkWidget *spin;
	SPIN_PACK *spp;
	gpointer sig_id;
	int *value;

	spp = spinPackAdd(id);
	sig_id = opt_address[id];

	hbox = gtk_hbox_new(FALSE, GTK_BORDER);

	if(map) pixmap = commonPixmapLoad(map);
  
	label = gtk_label_new(commonLabelCall(id, NULL));
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
  
	value = (int*)options[id];
	adj = gtk_adjustment_new(*value, param[0], param[1],
				 param[2], param[3], param[4]);
	spin = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0, 0);
	gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin), GTK_SHADOW_OUT);
	gtk_box_pack_start(GTK_BOX(hbox), spin, TRUE, TRUE, 0);
	gtk_widget_show(spin);
	gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
			   GTK_SIGNAL_FUNC(spinPackChengeValue), sig_id);

	if(map) spp->pixmap = pixmap;
	spp->label = label;
	spp->adj = adj;
	spp->spin = spin;
	return hbox;
}

/* ================================================== */
/*           adjustment_pack functions */
/* ================================================== */

static ADJUSTMENT_PACK* adjustmentPackAdd(int id)
{
	ADJUSTMENT_PACK *ap;

	ap = (ADJUSTMENT_PACK *)malloc(sizeof(ADJUSTMENT_PACK));
	ap->id = id;
	ap->pixmap = NULL;
	ap->label = NULL;
	ap->adj = NULL;
	ap->entry = NULL;
	ap->hscale = NULL;
	ap->max = 0.0;
	ap->min = 0.0;
	opt_address[id] = ap;
	return ap;
}


static void adjustmentPackSetSensitive(ADJUSTMENT_PACK *ap, int flag)
{
	if(ap->pixmap) gtk_widget_set_sensitive(ap->pixmap, flag);
	gtk_widget_set_sensitive(ap->label, flag);
	gtk_widget_set_sensitive(ap->entry, flag);
	gtk_widget_set_sensitive(ap->hscale, flag);
}


static void adjustmentPackChengeValue(GtkAdjustment *adj,
				      ADJUSTMENT_PACK *ap)
{
	int id, *new_value;
	GString *strval;

	id = ap->id;
	strval = g_string_new ("");
	g_string_sprintf (strval, "%i", (int)adj->value);

	if (strcmp (gtk_entry_get_text (GTK_ENTRY(ap->entry)), strval->str))
		gtk_entry_set_text(GTK_ENTRY(ap->entry), strval->str);
	g_string_free(strval, TRUE);

	new_value = (int *)options[id];
	*new_value = (int)adj->value;  
	return;
}


static void adjustmentPackChengeEntry(GtkWidget* widget,
				      ADJUSTMENT_PACK *ap)
{
	int id, *opt_value, i, check;
	char* strval;

	id = ap->id;
	opt_value = (int *)options[id];
	strval = (char*)gtk_entry_get_text(GTK_ENTRY(widget));

	check = 0;
	for (i = 0; i < strlen (strval); i++)
	{
		if (!isdigit (strval[i]))
			if (i != 0 || strval[i] != '-')
				check = 1;
	}

	if (!check)
	{
		double new_value;

		new_value = atof(strval);
		if ((double)new_value >= ap->min && (double)new_value <= ap->max)
		{
			*opt_value = (int)new_value;
			if (*opt_value != (double)((GtkAdjustment *)ap->adj)->value)
				gtk_adjustment_set_value(GTK_ADJUSTMENT(ap->adj),
							 (gfloat)*opt_value);
			return;		/* NO_ERROR */
		}
	}

	gtk_signal_handler_block_by_data (GTK_OBJECT(widget), (gpointer)ap);
	sprintf (strval, "%d", *opt_value);
	gtk_entry_set_text(GTK_ENTRY(widget), strval);
	gtk_signal_handler_unblock_by_data (GTK_OBJECT(widget), (gpointer)ap);
  
	return;
}

static void adjustmentPackCheckEntry(GtkWidget* widget,
				     GdkEvent* event, ADJUSTMENT_PACK *ap )
{
	int id, *opt_value, len;
	char* strval;

	/* check only for NULL */

	id = ap->id;
	opt_value = (int *)options[id];
	strval = (char*)gtk_entry_get_text(GTK_ENTRY(widget));

	
	len = strlen(strval);
	/* ʸ¸ߤƤ, 夬0ǤʤOK */
	if ((len == 0)
	    || ((len > 1) && (((strval[0] == '0') || (strval[0] == '-')) && (strval[1] == '0'))))
	{
		gtk_signal_handler_block_by_data (GTK_OBJECT(widget), (gpointer)ap);
		/* *opt_value = 0; */
		sprintf (strval, "%d", *opt_value );
		gtk_entry_set_text(GTK_ENTRY(widget), strval);
		gtk_signal_handler_unblock_by_data (GTK_OBJECT(widget), (gpointer)ap);
	}
	return;
}


GtkWidget* adjustmentPackNew(char *map, int id, double param[])
{
	GtkWidget *hbox;
	GtkWidget *pixmap=0;
	GtkWidget *label;
	GtkObject *adj;
	GtkWidget *entry;
	GtkWidget *hscale;
	GString *strval;
	ADJUSTMENT_PACK *ap;
	gpointer sig_id;
	int *value;


	ap = adjustmentPackAdd(id);
	sig_id = opt_address[id];
  
	hbox = gtk_hbox_new(FALSE, GTK_BORDER);

	if(map) pixmap = commonPixmapLoad(map);
  
	label = gtk_label_new(commonLabelCall(id, NULL));
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);

	value = (int*)options[id];
	entry = gtk_entry_new_with_max_length(3);
	strval = g_string_new("");
	g_string_sprintf(strval, "%i", *value);
	gtk_entry_set_text(GTK_ENTRY(entry), strval->str);
	g_string_free(strval, TRUE);
  
	gtk_widget_set_usize(entry, entry->style->font->ascent * 4,
			     entry->style->font->ascent +
			     entry->style->font->descent +
			     entry->style->klass->ythickness * 2);
	gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, TRUE, 0);
	gtk_widget_show(entry);
	gtk_signal_connect(GTK_OBJECT(entry), "changed",
			   GTK_SIGNAL_FUNC(adjustmentPackChengeEntry), sig_id);
	/* focus out */
	gtk_signal_connect(GTK_OBJECT(entry), "focus_out_event",
			   GTK_SIGNAL_FUNC(adjustmentPackCheckEntry), sig_id );

	adj = gtk_adjustment_new(*value, param[0], param[1],
				 param[2], param[3], param[4]);
  
	hscale = gtk_hscale_new(GTK_ADJUSTMENT(adj));
	gtk_scale_set_draw_value(GTK_SCALE(hscale), FALSE);
	gtk_widget_set_usize(hscale, 180, 14);
	gtk_box_pack_start(GTK_BOX(hbox), hscale, FALSE, TRUE, 0);
	gtk_widget_show(hscale);
	gtk_signal_connect(GTK_OBJECT(adj), "value_changed",
			   GTK_SIGNAL_FUNC(adjustmentPackChengeValue), sig_id);

	if(map) ap->pixmap = pixmap;
	ap->label = label;
	ap->adj = adj;
	ap->entry = entry;
	ap->hscale = hscale;
	ap->max = param[1];
	ap->min = param[0];
	return hbox;
}


/* ================================================== */
/*           io_pack functions */
/* ================================================== */

typedef struct _IO_PACK{
	char *label;
	GtkWidget *hbox;
} IO_PACK;

GtkWidget* ioPackNew(char *title, int flag)
{
	GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *entry;
	GtkWidget *button;
	GtkWidget *radio;
	GSList *group;
	IO_PACK *ip;

	frame = gtk_frame_new(title);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);

	vbox = gtk_vbox_new(FALSE, 5);
	hbox = gtk_hbox_new(FALSE, 10);

	entry = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(entry), FALSE);
	if(flag == INPUT){
		gtk_signal_connect(GTK_OBJECT(entry), "changed", GTK_SIGNAL_FUNC(ioPackChengeValue), input_file);
		gtk_entry_set_text(GTK_ENTRY(entry), input_file);
	}
	else{
		gtk_signal_connect(GTK_OBJECT(entry), "changed", GTK_SIGNAL_FUNC(ioPackChengeValue), output_file);
		gtk_entry_set_text(GTK_ENTRY(entry), output_file);
	}
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);
	gtk_widget_show(entry);

	button = ioPackButton(entry);
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
	gtk_widget_show(button);

	if(flag == OUTPUT){
		ip = (IO_PACK *)malloc(sizeof(IO_PACK));
		ip->hbox = hbox;
		radio = gtk_radio_button_new_with_label(NULL,
							(char*)_(outputLabels[0]));
		gtk_box_pack_start(GTK_BOX(vbox), radio, FALSE, TRUE, 0);
		ip->label = outputLabels[0];
		gtk_signal_connect(GTK_OBJECT(radio), "clicked",
				   GTK_SIGNAL_FUNC(ioOutputTypeSet), ip);
		gtk_widget_show(radio);

		group = gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
		radio = gtk_radio_button_new_with_label(group,
							(char*)_(outputLabels[1]));
		gtk_box_pack_start(GTK_BOX(vbox), radio, FALSE, TRUE, 0);
		gtk_signal_connect(GTK_OBJECT(radio), "clicked",
				   GTK_SIGNAL_FUNC(ioOutputTypeSet), NULL);
		gtk_widget_show(radio);
    
		opt_address[P_OUTPUT_EX] = ip;
	}

	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);
	if(flag == INPUT) gtk_widget_show(hbox);

	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_widget_show(vbox);

	gtk_container_set_border_width (GTK_CONTAINER (frame), GTK_BORDER);
	return frame;
}


static void ioOutputTypeSet(GtkWidget *widget, gpointer data)
{
	IO_PACK *ip;

	ip = (IO_PACK *)opt_address[P_OUTPUT_EX];
	if(data != NULL){
		output_type = 1;
		gtk_widget_hide(ip->hbox);
	}
	else{
		output_type = 0;
		gtk_widget_show(ip->hbox);
	}
}


static GtkWidget* ioPackButton(GtkWidget *entry)
{
	GtkWidget *button;
	char *name;

	name = ioLabels[2];
	button = gtk_button_new_with_label(_(name));
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(ioPackFileSelection), entry);

	return button;
}

static void ioPackFileSelection(GtkWidget *widget, GtkWidget *entry)
{
	GtkWidget *filewin;
	IO_SIGDATA *io_sig;

	io_sig = (IO_SIGDATA *)malloc(sizeof(IO_SIGDATA));

	filewin = gtk_file_selection_new("select file");
	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(filewin));
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filewin), gtk_entry_get_text(GTK_ENTRY(entry)));
	io_sig->entry = entry;
	io_sig->filewin = filewin;
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filewin)),
			   "delete_event", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filewin)->ok_button),
			   "clicked", GTK_SIGNAL_FUNC(ioPackOkSel), io_sig);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filewin)->cancel_button),
			   "clicked", GTK_SIGNAL_FUNC(ioPackCanSel), NULL);
	gtk_widget_show(filewin);

	gtk_grab_add(filewin);
	gtk_main();
	gtk_grab_remove(filewin);

	gtk_widget_destroy(filewin);
	g_free(io_sig);
}


static void ioPackOkSel(GtkWidget *widget, IO_SIGDATA *io_sig)
{
	char *name;
  
	if((name = gtk_file_selection_get_filename
	    (GTK_FILE_SELECTION(io_sig->filewin))) != NULL)
		gtk_entry_set_text(GTK_ENTRY(io_sig->entry), name);
	gtk_main_quit();
}


static void ioPackCanSel(GtkWidget *widget, IO_SIGDATA *io_sig)
{
	gtk_main_quit();
}


static void ioPackChengeValue(GtkEntry *entry, char *file)
{
	strcpy(file, gtk_entry_get_text(entry));
}


#ifdef CONV_VERSION2
/* ǥեȥޡͤˤ٤, ɲ
   ʤ̵                Mon Aug 28 2000 sk */
#include "paper.h"

GtkWidget*
margin_default_set_button (void)
{
	GtkWidget *button;
	char* name;

	name = def_margin_label;
	button = gtk_button_new_with_label(_(name));
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			   GTK_SIGNAL_FUNC(margin_default_set), NULL);
	return button;
}

static void
margin_default_set (GtkWidget *widget, void* data)
{
	LP_PAPER_CONF lp_paper;
	SPIN_PACK *mgx = (SPIN_PACK*)opt_address[P_MARGIN_X];
	SPIN_PACK *mgy = (SPIN_PACK*)opt_address[P_MARGIN_Y];

	lp_paper = call_paper_conf ((char*)options[P_BIN],
				    (char*)options[P_MEDIA_SIZE]);
  
	gtk_adjustment_set_value (GTK_ADJUSTMENT(mgx->adj),
				  (gfloat)DOT_TO_MM(lp_paper->margin_x));
	gtk_adjustment_set_value (GTK_ADJUSTMENT(mgy->adj),
				  (gfloat)DOT_TO_MM(lp_paper->margin_y));
  
	return;
}

static void
margin_abjset (void)
{
	LP_PAPER_CONF lp_paper;
	char bin_name[10];

	SPIN_PACK *mgx = (SPIN_PACK*)opt_address[P_MARGIN_X];
	SPIN_PACK *mgy = (SPIN_PACK*)opt_address[P_MARGIN_Y];

	strcpy (bin_name, (char*)options[P_BIN]);
	if (bin_name[0] == 'T')
	{
		gtk_widget_set_sensitive (mgx->spin, FALSE);
      
		if (bin_name[1] == '4')
		{
			gtk_widget_set_sensitive (mgy->spin, FALSE);
		}
		else
		{
			gtk_widget_set_sensitive (mgy->spin, TRUE);
		}
	}
	else
	{
		gtk_widget_set_sensitive (mgx->spin, TRUE);
		gtk_widget_set_sensitive (mgy->spin, TRUE);
	}

	lp_paper = call_paper_conf (bin_name, (char*)options[P_MEDIA_SIZE]);

	margin_updata (P_MARGIN_X, lp_paper->margin_x, lp_paper->margin_x + lp_paper->area_x);
	margin_updata (P_MARGIN_Y, lp_paper->margin_y, lp_paper->margin_y + lp_paper->area_y);

	return;
}

static void
margin_updata (int id, long def, long max)
{
	GtkAdjustment *adj;  
	SPIN_PACK *mg = (SPIN_PACK*)opt_address[id];

	adj = gtk_spin_button_get_adjustment (GTK_SPIN_BUTTON(mg->spin));
	adj->upper = DOT_TO_MM(max)  - 1; /* ޡͤ1mmʤꤹ */
	gtk_spin_button_set_adjustment (GTK_SPIN_BUTTON(mg->spin), GTK_ADJUSTMENT(adj));
	if (*((int*)options[id]) > DOT_TO_MM(max) - 1) /* Ʊͤ˥ޡͤ򾯤ʤ */
		gtk_adjustment_set_value (GTK_ADJUSTMENT(adj), (gfloat)DOT_TO_MM(def));

	return;
}
#endif /* CONV_VERSION2 */


/* Utility  -add Mon Feb 12 2001 */

#if (USE_INKBOX)
static void getInkVol (char *, InkList *);
static void setInkboxProg (char *);
#else
static void setInkProgress (char *);
#endif /* USE_INKBOX */

static void checkInkResidual (char *);
static void commandButtonClicked (GtkWidget *, char *);
static int utilInkChecker (char*);
static GtkWidget* createMsgErr (char*);

GtkWidget*
commandButtonNew (char* text)
{
	GtkWidget *hbox, *label, *button;
  
	hbox = gtk_hbox_new(TRUE, GTK_BORDER);

	label = gtk_label_new(text);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);
  
	button = gtk_button_new_with_label("OK");
	gtk_signal_connect (GTK_OBJECT(button), "clicked",
			    GTK_SIGNAL_FUNC(commandButtonClicked), text);
	/*    gtk_widget_set_usize (GTK_WIDGET(button), 0, 20); */
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
	gtk_widget_show(button);
  
	return hbox;
}


GtkWidget*
progressPackNew (char* text)
{
	GtkWidget *hbox, *label, *prog;

	hbox = gtk_hbox_new(TRUE, GTK_BORDER);

	label = gtk_label_new (text);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 0);
	gtk_widget_show(label);

	prog = gtk_progress_bar_new ();
	gtk_box_pack_start(GTK_BOX(hbox), prog, TRUE, TRUE, 0);
	gtk_widget_show(prog);

	if (strcmp (text, (char *)_(Ink_Black)) == 0)
	{
		pips_util_pack.black_prog = prog;
	}
	else
	{
		pips_util_pack.color_prog = prog;
	}

	return hbox;
}


GtkWidget *
inkboxPackNew (void)
{
	GtkWidget *hbox;
	GdkPixmap *inkbox_pixmap;
	GdkBitmap *inkbox_mask;
	GdkColormap *colormap;

	int i;

	hbox = gtk_hbox_new(TRUE, GTK_BORDER);

	for (i = 0; i < INK_NUMBER; i ++)
	{
		colormap = gtk_widget_get_colormap (pips_util_pack.main_widget);

		inkbox_pixmap = gdk_pixmap_colormap_create_from_xpm_d (NULL,
								       colormap, &inkbox_mask, NULL,
							      (gchar**)pips_util_pack.inkbox_xpm);
/*
		inkbox_pixmap = gdk_pixmap_create_from_xpm_d (pips_util_pack.main_widget->window,
							      &inkbox_mask, NULL,
							      (gchar**)pips_util_pack.inkbox_xpm);
*/
		pips_util_pack.inkbox_widget[i] = gtk_pixmap_new(inkbox_pixmap,
								 inkbox_mask);
		gtk_box_pack_start(GTK_BOX(hbox),
				   pips_util_pack.inkbox_widget[i],
				   TRUE, TRUE, 0);
		gtk_widget_hide (pips_util_pack.inkbox_widget[i]);

		gdk_pixmap_unref (inkbox_pixmap);
		gdk_bitmap_unref (inkbox_mask);
	}
	return hbox;
}

int
getInkStatus (void *data)
{
	char rep_buf[REPLAY_SIZE];
#ifdef	INK_CHANGE_SYSTEM 
	int inkset;
#endif
	get_status (rep_buf);

	checkInkResidual (rep_buf);

#if  (USE_INKBOX)
	setInkboxProg (rep_buf);
	if (pips_util_pack.inkbox_use_flag[0] == 1)
	{
#else
	setInkProgress (rep_buf);
	if (strstr(rep_buf, "IQ:"))
	{
#endif
		gtk_widget_hide (pips_util_pack.no_connect_frame);
		gtk_widget_show (pips_util_pack.connect_frame);
	}
	else
	{
		gtk_widget_hide (pips_util_pack.connect_frame);
		gtk_widget_show (pips_util_pack.no_connect_frame);
	}

#ifdef	INK_CHANGE_SYSTEM 
	/* 󥯤򴹤줿å */
        inkset = get_inkset();
	if( strcmp( options[P_INKSET], getRscName(P_INKSET, inkset) )  ){

		/* ɽ */
		GtkWidget *widget;
		widget = createMsgErr (_(Ink_Change));
		gtk_widget_show (widget);

		/* Ink Change System б 		 */
		/* Ink򴹤줿Υǥե */
  		options[P_MEDIA_TYPE]    =  getRscName( P_MEDIA_TYPE, PIPS_MED_PLAIN );
  		options[P_HALF_TONE]     =  getRscName( P_HALF_TONE, PIPS_HT_QUALITY);
#if	(SP2100_2200) || (PM4000PX)
 		options[P_QUALITY_LEVEL] =  getRscName( P_QUALITY_LEVEL, PIPS_LV_STD );
  		options[P_RESOLUTION]    =  getRscName( P_RESOLUTION, 360 );
  		options[P_HIGH_SPEED]    =  getRscName( P_HIGH_SPEED, PIPS_HS_OFF );
  		options[P_MICRO_WEAVE]   =  getRscName( P_MICRO_WEAVE,PIPS_MW_ON );
#elif	(PM980C)
 		options[P_QUALITY_LEVEL] =  getRscName( P_QUALITY_LEVEL, PIPS_LV_FINE720 );
  		options[P_RESOLUTION]    =  getRscName( P_RESOLUTION, 360 );
  		options[P_HIGH_SPEED]    =  getRscName( P_HIGH_SPEED, PIPS_HS_OFF );
  		options[P_MICRO_WEAVE]   =  getRscName( P_MICRO_WEAVE,PIPS_MW_OFF );
#endif

		/* ߤΥ󥯤 */
  		options[P_INKSET ]       =  getRscName( P_INKSET, inkset );
  		commonSetOptionsSensitive ();
	}
#endif


	return 1;		       /* timerƤӽФؿTRUE֤ʤȽλƤޤ */
}

static void
checkInkResidual (char *buf)
{
	char* point;

	point = strstr (buf, "ER:");
	if (point != NULL && (memcmp (point + 3, "05", 2) == 0))
	{
		pips_util_pack.ink_low_flag = ST_INK_END;
		return;
	}

	point = strstr (buf, "WR:");
	if (point != NULL)
	{
		pips_util_pack.ink_low_flag = ST_INK_LOW;
		return;
	}

	pips_util_pack.ink_low_flag = ST_INK_NORMAL;
	return;
}

#if (USE_INKBOX==0)
static void
setInkProgress (char *buf)
{
	char* point;

	point = strstr(buf, "IQ:");
	if (point)
	{
		char K[3], C[3], M[3], Y[3];
		char LC[3], LM[3], DY[3];
		int rest, black_rest, color_rest;
		char *stopstring;

		memcpy (K, "-1", 3);
		memcpy (C, "-1", 3);
		memcpy (M, "-1", 3);
		memcpy (Y, "-1", 3);
		memcpy (LC, "-1", 3);
		memcpy (LM, "-1", 3);
		memcpy (DY, "-1", 3);

		black_rest = color_rest = 0;
		strncpy (K, point + 3, 2);
		strncpy (C, point + 5, 2);
		strncpy (M, point + 7, 2);
		strncpy (Y, point + 9, 2);

      		if (point[11] != ';')	/* 6 ink */
		{
			strncpy(LC, point + 11, 2);
			strncpy(LM, point + 13, 2);
			
			if (point[15] != ';')	/* 7 ink */
				strncpy(DY, point + 15, 2);
		}

		black_rest = (gint)strtol (K, &stopstring, 16);
		color_rest = (gint)strtol (C, &stopstring, 16);
      
		rest = strtol (M, &stopstring, 16);
		color_rest = (rest < color_rest) ? rest : color_rest;
		rest = strtol(Y, &stopstring, 16);
		color_rest = (rest < color_rest) ? rest : color_rest;

		rest = strtol (LC, &stopstring, 16);
		if ((rest >= 0) && ((gint)rest < color_rest)) color_rest = (gint)rest; 
    
		rest = strtol (LM, &stopstring, 16);
		if ((rest >= 0) && ((gint)rest < color_rest)) color_rest = (gint)rest; 

		rest = strtol (DY, &stopstring, 16);
		if ((rest >= 0) && ((gint)rest < color_rest)) color_rest = (gint)rest; 


		gtk_progress_bar_update(GTK_PROGRESS_BAR(pips_util_pack.black_prog),
					(gfloat)black_rest / 100.0);
		gtk_progress_bar_update(GTK_PROGRESS_BAR(pips_util_pack.color_prog),
					(gfloat)color_rest / 100.0);
		gtk_widget_hide (pips_util_pack.no_connect_frame);
		gtk_widget_show (pips_util_pack.connect_frame);
	}
	else
	{
		gtk_widget_hide (pips_util_pack.connect_frame);
		gtk_widget_show (pips_util_pack.no_connect_frame);
	}
	return;
}

#else /* USE_INKBOX */
static void
getInkVol (char *buf, InkList *list  )
{
	char* lpInk;

	/* 󥯼 */
	lpInk = strstr (buf, "INK:");
	if (lpInk){
		char ic[7] = "0x";
		InkNode *prev = NULL;

		lpInk += 4;	/* skip "INK:" */
		while (*lpInk != ';') {
			InkNode *node;

			node = (InkNode *)calloc(1, sizeof(InkNode));
			if (!node) {
				return;
			}

			memcpy(ic + 2, lpInk, 4);
			*(ic + 6) = '\0';
			node->id = strtol(ic, (char **)NULL, 16);
			
			if (prev) {
				prev->next = node;
				prev = prev->next;
			} else {
				prev = node;
				*list = prev;
			}
			lpInk += 4;
			if (*lpInk == ',') {
				lpInk++;
			}
			node = node->next;
		}
	}

	/* 󥯻̲ */
	lpInk = strstr(buf, "IQ:");
	if(lpInk){
	        char ink[3];
		char *stopstring;
		InkNode *node = *list;

		lpInk += 3;
		memset (ink, 0, 3);
		while (node)
		{
			strncpy(ink, lpInk, 2);
			node->rest = (gint)strtol (ink, &stopstring, 16);
			node = node->next;
			lpInk +=2;
			if (*lpInk == ';') break;
		}
	}
}

static void
ink_list_delete (InkList list)
{
	InkNode *node;

	while (list) {
		node = list->next;
		free(list);
		list = node;
	}
	return;
}


static void
setInkboxProg (char *buffer)
{
	GdkPixmap *inkbox_pixmap;
	GdkBitmap *inkbox_mask;
	int inkset;
	int i;
	InkList list;
	InkNode *node;

	list = NULL;
	getInkVol (buffer, &list );

	inkset = get_inkset ();

	node = list;
	while (node) {
		if (node->rest < 0 || node->rest > 100)
			pips_util_pack.inkbox_use_flag[0] = 0;
		node = node->next;
	}
	
	node = list;
	if (pips_util_pack.inkbox_use_flag[0] != 0 && node != NULL ){
		if (pips_util_pack.inkbox_use_flag[pips_util_pack.inkbox_counter] == 0
		    || pips_util_pack.inkbox_counter >= INK_NUMBER)
			pips_util_pack.inkbox_counter = 0;
		
		for (i = 0; i < pips_util_pack.inkbox_counter; i++) {
			if (!node) {
				pips_util_pack.inkbox_use_flag[0] = 0;
				return;
			}
			node = node->next;
		}
		
		i = pips_util_pack.inkbox_counter;
  	
		inkbox_chenge_volume (pips_util_pack.inkbox_xpm, node->id, node->rest);
		inkbox_pixmap = gdk_pixmap_create_from_xpm_d(pips_util_pack.main_widget->window,
							     &inkbox_mask, NULL,
							     pips_util_pack.inkbox_xpm);
		gtk_pixmap_set(GTK_PIXMAP(pips_util_pack.inkbox_widget[i]), inkbox_pixmap,inkbox_mask);
		
		gtk_widget_show (pips_util_pack.inkbox_widget[i]);
 	        pips_util_pack.inkbox_use_flag[pips_util_pack.inkbox_counter] = 1;
		pips_util_pack.inkbox_counter++;
	}else{
		for (i = 0; i < INK_NUMBER; i++){
			
			if (node != NULL && (node->rest >= 0 && node->rest <= 100)){
				inkbox_chenge_volume (pips_util_pack.inkbox_xpm, node->id, node->rest);
				inkbox_pixmap = gdk_pixmap_create_from_xpm_d(pips_util_pack.main_widget->window,
									     &inkbox_mask, NULL,
									     (gchar**)pips_util_pack.inkbox_xpm);
	  	                gtk_pixmap_set(GTK_PIXMAP(pips_util_pack.inkbox_widget[i]), inkbox_pixmap,inkbox_mask);
				pips_util_pack.inkbox_use_flag[i] = 1;
		                gtk_widget_show (pips_util_pack.inkbox_widget[i]);
				node = node->next;
			}else{
				pips_util_pack.inkbox_use_flag[i] = 0;
		                gtk_widget_hide (pips_util_pack.inkbox_widget[i]);
			}
		}
	}

	/* cleanup */
	ink_list_delete(list);

	return;
}
#endif /* USE_INKBOX */


static void
commandButtonClicked (GtkWidget *widget, char* text)
{
	/* D4
	   int nwrite;
	   char pattern_command[] = { 'n', 'c', 0x01, 0x00, 0x00 };
	   char cleaning_command[] = { 'c', 'h', 0x01, 0x00, 0x01 };
  */
	char pattern_command[] = {
		0x00, 0x00, 0x00, 0x1b, 0x01, 0x40, 0x45, 0x4a,
		0x4c, 0x20, 0x31, 0x32, 0x38, 0x34, 0x2e, 0x34,
		0x0a, 0x40, 0x45, 0x4a, 0x4c, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x0a,
    
		0x1b, 0x40, 0x1b, 0x40,
		0x1b, 0x28, 0x52, 0x08, 0x00, 0x00, 0x52, 0x45,
		0x4d, 0x4f, 0x54, 0x45, 0x31,

#if PMG800
		'P', 'P', 0x03, 0x00, 0x00, 0x01,0xff,
		'N', 'C', 0x02, 0x00, 0x00, 0x10,
#else
		'N', 'C', 0x02, 0x00, 0x00, 0x00,
#endif

		0x1b, 0x00, 0x00, 0x00,
		0x0d, 0x0a, 0x0d, 0x0a,

		0x1b, 0x40, 0x1b, 0x40,
		0x1b, 0x28, 0x52, 0x08, 0x00, 0x00, 0x52, 0x45,
		0x4d, 0x4f, 0x54, 0x45, 0x31,

		'V', 'I', 0x02, 0x00, 0x00, 0x00,
		/*  'J', 'E', 0x01, 0x00, 0x00, */

		0x1b, 0x00, 0x00, 0x00,
		0x0c,

		0x1b, 0x40, 0x1b, 0x40
	};

	char cleaning_command[] = {
		0x00, 0x00, 0x00, 0x1b, 0x01, 0x40, 0x45, 0x4a,
		0x4c, 0x20, 0x31, 0x32, 0x38, 0x34, 0x2e, 0x34,
		0x0a, 0x40, 0x45, 0x4a, 0x4c, 0x20, 0x20, 0x20,
		0x20, 0x20, 0x0a,
    
		0x1b, 0x40, 0x1b, 0x40,
		0x1b, 0x28, 0x52, 0x08, 0x00, 0x00, 0x52, 0x45,
		0x4d, 0x4f, 0x54, 0x45, 0x31,

		'C', 'H', 0x02, 0x00, 0x00, 0x00,
		/*  'J', 'E', 0x01, 0x00, 0x00, */
    
		0x1b, 0x00, 0x00, 0x00,

		0x1b, 0x40, 0x1b, 0x40
	};
	FILE* fp;
	char navi_command[256];

	if (!strcmp (text, _(Status_Monitor)))
	{
		system ("ekpstm 2> /dev/null &");
	}
	else
	{
		char prt_command[107];
      

		if (utilInkChecker (text))
			return;

		strcpy (prt_command, "lpr -P");
		get_prt_name (prt_command + 6);
      
		if (!strcmp (text, _(Nozzle_Check)))
		{
			fp = popen (prt_command, "w");
			fwrite (pattern_command, sizeof (pattern_command), 1, fp);
			pclose (fp);
			/* D4
			   nwrite = sizeof (pattern_command);
			   sock_write_abandon_reply (pattern_command, &nwrite);
			*/
		}

		else if (!strcmp (text, _(Head_Cleaning)))
		{
			fp = popen (prt_command, "w");
			fwrite (cleaning_command, sizeof (cleaning_command), 1, fp);
			pclose (fp);
			/* D4
			   nwrite = sizeof (cleaning_command);
			   sock_write_abandon_reply (cleaning_command, &nwrite);
			*/
		}

		else
		{
			/* !!!! ¸ */
			if (!strcmp (text, _(Print_Head_Alignment)))
			{
#if (PM880C) || (PM3500C) 
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --ruled 3 --patch 2 --platen", prt_command);
#elif (PM3700C) 
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --extension \"%s\" --ruled 3 --patch 2 --platen", prt_command, PRINTER_MODEL);
#elif (PM900C) || (PM920C)
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --ruled 2 --patch 1 --platen", prt_command);
#elif (SC40S) || (SC20S) || (SP810_820) || (PM730C) || (SC60S) || (SC41_42S) \
   || (SC61_62S) || (PM740C) || (PM740DU) || (CL760) || (SC43S) || (SP830U)
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --ruled 3 --rpath " RULED_PATH , prt_command);
#elif (SC980)
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --ruled 2", prt_command);
#elif (PM830C)
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --ruled 3 --patch 2 --ppath " PATCH_PATH , prt_command);
#elif (SC70S) || (SC80S)
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --ruled 4 --band 1 --bpath " BAND_PATH , prt_command);
#elif (PM890C) || (PM950C) || (PM850PT) || (PM840C) || (SP960) || (SP925) \
   || (PM870C) || (PM930C) || (PM860PT) || (SP2100_2200) || (PM4000PX) \
   || (PM939C) || (PMG700) || (PMG800)  || (PMA850) || (PMD750)
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --extension \"%s\" --ppath " PATCH_PATH , prt_command, PRINTER_MODEL);
#elif  (SC64_63S) || (PXV600) || (SC84_83S)
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --extension \"%s\" --ppath " PATCH_PATH " --bpath " BAND_PATH, prt_command, PRINTER_MODEL);

#elif  (SC82S) || (PXV700) || (CC600PX) || (SCX5100_5200S)
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --extension \"%s\" --rpath " RULED_PATH " --bpath " BAND_PATH , prt_command, PRINTER_MODEL);
#elif  (PM970C) || (PM980C)
 				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --extension \"%s\" --rpath " RULED_PATH " --ppath " PATCH_PATH , prt_command, PRINTER_MODEL);
#else
				sprintf (navi_command, NAVI_PATH " --alignment --printer \"%s\" --ruled 3", prt_command);
#endif
			}
			else if (!strcmp (text, _(Ink_Chenge)))
				sprintf (navi_command, NAVI_PATH " --ink");

			else if (!strcmp (text, _(Auto_Cutter_Adjustment)))
				sprintf (navi_command, NAVI_PATH " --cut --printer \"%s\" --extension \"%s\" --cpath " CUT_PATH, prt_command, PRINTER_MODEL);
/*
			fprintf (stderr, "Debug : navi_command : %s\n", navi_command); 
*/
			strcat (navi_command, " 2> /dev/null");
//			strcat (navi_command, " 2> /tmp/navi.dmp");
			system (navi_command);
		}
	}
	return;
}

static int
utilInkChecker (char* text)
{
	if ((pips_util_pack.ink_low_flag == ST_INK_END)
	    || (pips_util_pack.ink_low_flag == ST_INK_LOW
		&& !strcmp (text, _(Head_Cleaning))))
	{
		GtkWidget *widget;

		widget = createMsgErr (text);
		gtk_widget_show (widget);

		return 1;
	}
	return 0;
}

void
push_ok (GtkButton *button, gpointer p_dialog)
{
	gtk_widget_destroy (p_dialog);
	return;
}

static GtkWidget*
createMsgErr (char* text)
{
	GtkWidget *msg_dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *label;
	GtkWidget *dialog_action_area1;
	GtkWidget *msg_ok_button;

	if (!strcmp (text, _(Nozzle_Check)))
		label = gtk_label_new (_(Nozzle_Check_Err_Msg));

	else if (!strcmp (text, _(Head_Cleaning)))
		label = gtk_label_new (_(Head_Cleaning_Err_Msg));

	else if (!strcmp (text, _(Print_Head_Alignment)))
		label = gtk_label_new (_(Head_Alignment_Err_Msg));

	else if (!strcmp (text, _(Ink_Change)))
		label = gtk_label_new (_(Ink_Change_Msg));

	else
		label = gtk_label_new (_(Utility_Err_Msg));


	msg_dialog = gtk_dialog_new ();
	gtk_object_set_data (GTK_OBJECT (msg_dialog), "msg_err", msg_dialog);
	
	/* Ink Change ξ ȥѹ */
	gtk_window_set_title (GTK_WINDOW (msg_dialog), 
		!strcmp (text, _(Ink_Change)) ? _("Ink Change System"): _("Error"));
	
	GTK_WINDOW (msg_dialog)->type = GTK_WINDOW_DIALOG;
	gtk_window_set_modal (GTK_WINDOW (msg_dialog), TRUE);
	gtk_window_set_policy (GTK_WINDOW (msg_dialog), FALSE, FALSE, FALSE);

	dialog_vbox = GTK_DIALOG (msg_dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (msg_dialog), "dialog_vbox", dialog_vbox);
	gtk_widget_show (dialog_vbox);

	gtk_widget_ref (label);
	gtk_object_set_data_full (GTK_OBJECT (msg_dialog), "label", label,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), label, FALSE, FALSE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_misc_set_padding (GTK_MISC (label), 20, 20);

	dialog_action_area1 = GTK_DIALOG (msg_dialog)->action_area;
	gtk_object_set_data (GTK_OBJECT (msg_dialog), "dialog_action_area1", dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

	msg_ok_button = gtk_button_new_with_label (_("OK"));
	gtk_widget_ref (msg_ok_button);
	gtk_object_set_data_full (GTK_OBJECT (msg_dialog), "msg_ok_button", msg_ok_button,
				  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (msg_ok_button);
	gtk_box_pack_start (GTK_BOX (dialog_action_area1), msg_ok_button, FALSE, TRUE, 0);

	gtk_signal_connect (GTK_OBJECT (msg_ok_button), "clicked",
			    GTK_SIGNAL_FUNC (push_ok),
			    msg_dialog);

	return msg_dialog;
}

#endif /* USE_GTK */
