/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `ekpnavi' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

GtkWidget*
create_ekpnavi_dialog (void)
{
  GtkWidget *ekpnavi_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *vbox1;
  GtkWidget *st_pix;
  GtkWidget *scrolledwindow1;
  GtkWidget *message;
  GtkWidget *align_combo;
  GtkWidget *hbox2;
  GtkWidget *align_label_1;
  GtkWidget *align_combo_1;
  GList *align_combo_1_items = NULL;
  GtkWidget *align_entry_1;
  GtkWidget *hbox3;
  GtkWidget *align_label_2;
  GtkWidget *align_combo_2;
  GList *align_combo_2_items = NULL;
  GtkWidget *align_entry_2;
  GtkWidget *hbox4;
  GtkWidget *align_label_3;
  GtkWidget *align_combo_3;
  GList *align_combo_3_items = NULL;
  GtkWidget *align_entry_3;
  GtkWidget *hbox5;
  GtkWidget *align_label_4;
  GtkWidget *align_combo_4;
  GList *align_combo_4_items = NULL;
  GtkWidget *align_entry_4;
  GtkWidget *hbox6;
  GtkWidget *align_label_5;
  GtkWidget *align_combo_5;
  GList *align_combo_5_items = NULL;
  GtkWidget *align_entry_5;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox1;
  GtkWidget *cancel_button;
  GtkWidget *prev_button;
  GtkWidget *ink_black_button;
  GtkWidget *ink_color_button;
  GtkWidget *retry_button;
  GtkWidget *next_button;
  GtkWidget *ok_button;
/*   GtkAccelGroup *accel_group; */

/*   accel_group = gtk_accel_group_new (); */

  ekpnavi_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (ekpnavi_dialog), "ekpnavi_dialog", ekpnavi_dialog);
  gtk_widget_set_usize (ekpnavi_dialog, 400, -2);
  gtk_window_set_title (GTK_WINDOW (ekpnavi_dialog), _("ekpnavi"));
  GTK_WINDOW (ekpnavi_dialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_policy (GTK_WINDOW (ekpnavi_dialog), FALSE, TRUE, TRUE);

  dialog_vbox1 = GTK_DIALOG (ekpnavi_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (ekpnavi_dialog), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  st_pix = create_pixmap (ekpnavi_dialog, NULL);
  gtk_widget_ref (st_pix);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "st_pix", st_pix,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (st_pix);
  gtk_box_pack_start (GTK_BOX (vbox1), st_pix, TRUE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (st_pix), 10, 10);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 10);
  gtk_widget_set_usize (scrolledwindow1, -2, 100);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 20);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

  message = gtk_text_new (NULL, NULL);
  gtk_widget_ref (message);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "message", message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), message);

  align_combo = gtk_hbox_new (TRUE, 20);
  gtk_widget_ref (align_combo);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_combo", align_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (align_combo);
  gtk_box_pack_start (GTK_BOX (vbox1), align_combo, TRUE, TRUE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (align_combo), 20);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (align_combo), hbox2, TRUE, TRUE, 0);

  align_label_1 = gtk_label_new (_("#1"));
  gtk_widget_ref (align_label_1);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_label_1", align_label_1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox2), align_label_1, FALSE, FALSE, 0);

  align_combo_1 = gtk_combo_new ();
  gtk_widget_ref (align_combo_1);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_combo_1", align_combo_1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox2), align_combo_1, TRUE, TRUE, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (align_combo_1), TRUE, FALSE);
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("1"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("2"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("3"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("4"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("5"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("6"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("7"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("8"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("9"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("10"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("11"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("12"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("13"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("14"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("15"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("16"));
  align_combo_1_items = g_list_append (align_combo_1_items, (gpointer) _("17"));
  gtk_combo_set_popdown_strings (GTK_COMBO (align_combo_1), align_combo_1_items);
  g_list_free (align_combo_1_items);

  align_entry_1 = GTK_COMBO (align_combo_1)->entry;
  gtk_widget_ref (align_entry_1);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_entry_1", align_entry_1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (align_entry_1);
  gtk_entry_set_editable (GTK_ENTRY (align_entry_1), FALSE);
  gtk_entry_set_text (GTK_ENTRY (align_entry_1), _("8"));

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (align_combo), hbox3, TRUE, TRUE, 0);

  align_label_2 = gtk_label_new (_("#2"));
  gtk_widget_ref (align_label_2);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_label_2", align_label_2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox3), align_label_2, FALSE, FALSE, 0);

  align_combo_2 = gtk_combo_new ();
  gtk_widget_ref (align_combo_2);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_combo_2", align_combo_2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox3), align_combo_2, TRUE, TRUE, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (align_combo_2), TRUE, FALSE);
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("1"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("2"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("3"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("4"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("5"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("6"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("7"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("8"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("9"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("10"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("11"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("12"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("13"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("14"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("15"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("16"));
  align_combo_2_items = g_list_append (align_combo_2_items, (gpointer) _("17"));
  gtk_combo_set_popdown_strings (GTK_COMBO (align_combo_2), align_combo_2_items);
  g_list_free (align_combo_2_items);

  align_entry_2 = GTK_COMBO (align_combo_2)->entry;
  gtk_widget_ref (align_entry_2);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_entry_2", align_entry_2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (align_entry_2);
  gtk_entry_set_editable (GTK_ENTRY (align_entry_2), FALSE);
  gtk_entry_set_text (GTK_ENTRY (align_entry_2), _("8"));

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox4);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "hbox4", hbox4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (align_combo), hbox4, TRUE, TRUE, 0);

  align_label_3 = gtk_label_new (_("#3"));
  gtk_widget_ref (align_label_3);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_label_3", align_label_3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox4), align_label_3, FALSE, FALSE, 0);

  align_combo_3 = gtk_combo_new ();
  gtk_widget_ref (align_combo_3);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_combo_3", align_combo_3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox4), align_combo_3, TRUE, TRUE, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (align_combo_3), TRUE, FALSE);
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("1"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("2"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("3"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("4"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("5"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("6"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("7"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("8"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("9"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("10"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("11"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("12"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("13"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("14"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("15"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("16"));
  align_combo_3_items = g_list_append (align_combo_3_items, (gpointer) _("17"));
  gtk_combo_set_popdown_strings (GTK_COMBO (align_combo_3), align_combo_3_items);
  g_list_free (align_combo_3_items);

  align_entry_3 = GTK_COMBO (align_combo_3)->entry;
  gtk_widget_ref (align_entry_3);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_entry_3", align_entry_3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (align_entry_3);
  gtk_entry_set_editable (GTK_ENTRY (align_entry_3), FALSE);
  gtk_entry_set_text (GTK_ENTRY (align_entry_3), _("8"));

  hbox5 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox5);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "hbox5", hbox5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox5);
  gtk_box_pack_start (GTK_BOX (align_combo), hbox5, TRUE, TRUE, 0);

  align_label_4 = gtk_label_new (_("#4"));
  gtk_widget_ref (align_label_4);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_label_4", align_label_4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox5), align_label_4, FALSE, FALSE, 0);

  align_combo_4 = gtk_combo_new ();
  gtk_widget_ref (align_combo_4);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_combo_4", align_combo_4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox5), align_combo_4, TRUE, TRUE, 0);
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("1"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("2"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("3"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("4"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("5"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("6"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("7"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("8"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("9"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("10"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("11"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("12"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("13"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("14"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("15"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("16"));
  align_combo_4_items = g_list_append (align_combo_4_items, (gpointer) _("17"));
  gtk_combo_set_popdown_strings (GTK_COMBO (align_combo_4), align_combo_4_items);
  g_list_free (align_combo_4_items);

  align_entry_4 = GTK_COMBO (align_combo_4)->entry;
  gtk_widget_ref (align_entry_4);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_entry_4", align_entry_4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (align_entry_4);
  gtk_entry_set_editable (GTK_ENTRY (align_entry_4), FALSE);
  gtk_entry_set_text (GTK_ENTRY (align_entry_4), _("8"));

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox6);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "hbox6", hbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (align_combo), hbox6, TRUE, TRUE, 0);

  align_label_5 = gtk_label_new (_("#5"));
  gtk_widget_ref (align_label_5);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_label_5", align_label_5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox6), align_label_5, FALSE, FALSE, 0);

  align_combo_5 = gtk_combo_new ();
  gtk_widget_ref (align_combo_5);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_combo_5", align_combo_5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox6), align_combo_5, TRUE, TRUE, 0);
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("1"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("2"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("3"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("4"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("5"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("6"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("7"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("8"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("9"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("10"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("11"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("12"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("13"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("14"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("15"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("16"));
  align_combo_5_items = g_list_append (align_combo_5_items, (gpointer) _("17"));
  gtk_combo_set_popdown_strings (GTK_COMBO (align_combo_5), align_combo_5_items);
  g_list_free (align_combo_5_items);

  align_entry_5 = GTK_COMBO (align_combo_5)->entry;
  gtk_widget_ref (align_entry_5);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "align_entry_5", align_entry_5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (align_entry_5);
  gtk_entry_set_text (GTK_ENTRY (align_entry_5), _("1"));

  dialog_action_area1 = GTK_DIALOG (ekpnavi_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (ekpnavi_dialog), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox1);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "hbuttonbox1", hbuttonbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbuttonbox1, TRUE, TRUE, 0);

  cancel_button = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_ref (cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "cancel_button", cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), cancel_button);

  prev_button = gtk_button_new_with_label (_("Back"));
  gtk_widget_ref (prev_button);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "prev_button", prev_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), prev_button);

  ink_black_button = gtk_button_new_with_label (_("Black"));
  gtk_widget_ref (ink_black_button);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "ink_black_button", ink_black_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), ink_black_button);

  ink_color_button = gtk_button_new_with_label (_("Color"));
  gtk_widget_ref (ink_color_button);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "ink_color_button", ink_color_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), ink_color_button);

  retry_button = gtk_button_new_with_label (_("Retry"));
  gtk_widget_ref (retry_button);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "retry_button", retry_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), retry_button);

  next_button = gtk_button_new_with_label (_("Next"));
  gtk_widget_ref (next_button);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "next_button", next_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), next_button);
#if 0
  GTK_WIDGET_SET_FLAGS (next_button, GTK_CAN_DEFAULT); 
  gtk_widget_add_accelerator (next_button, "clicked", accel_group, 
                               GDK_Return, 0, 
                               GTK_ACCEL_VISIBLE); 
#endif

  ok_button = gtk_button_new_with_label (_("OK"));
  gtk_widget_ref (ok_button);
  gtk_object_set_data_full (GTK_OBJECT (ekpnavi_dialog), "ok_button", ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), ok_button);

#if 0
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT); 
  gtk_widget_add_accelerator (ok_button, "clicked", accel_group, 
                                 GDK_Return, 0, 
                                 GTK_ACCEL_VISIBLE); 
#endif
  

  gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (on_cancel_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (prev_button), "clicked",
                      GTK_SIGNAL_FUNC (on_prev_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (ink_black_button), "clicked",
                      GTK_SIGNAL_FUNC (on_ink_black_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (ink_color_button), "clicked",
                      GTK_SIGNAL_FUNC (on_ink_color_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (retry_button), "clicked",
                      GTK_SIGNAL_FUNC (on_retry_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (next_button), "clicked",
                      GTK_SIGNAL_FUNC (on_next_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      GTK_SIGNAL_FUNC (on_ok_button_clicked),
                      NULL);

  gtk_widget_grab_focus (ok_button);
  gtk_widget_grab_default (ok_button);
  /* gtk_window_add_accel_group (GTK_WINDOW (ekpnavi_dialog), accel_group); */

  return ekpnavi_dialog;
}

GtkWidget*
create_msg_dialog (void)
{
  GtkWidget *msg_dialog;
  GtkWidget *dialog_vbox7;
  GtkWidget *msg_label;
  GtkWidget *dialog_action_area7;
  GtkWidget *msg_ok_button;

  msg_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (msg_dialog), "msg_dialog", msg_dialog);
  gtk_window_set_title (GTK_WINDOW (msg_dialog), _("Warning"));
  GTK_WINDOW (msg_dialog)->type = GTK_WINDOW_DIALOG;
  gtk_window_set_modal (GTK_WINDOW (msg_dialog), TRUE);
  gtk_window_set_policy (GTK_WINDOW (msg_dialog), FALSE, FALSE, TRUE);

  dialog_vbox7 = GTK_DIALOG (msg_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (msg_dialog), "dialog_vbox7", dialog_vbox7);
  gtk_widget_show (dialog_vbox7);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_vbox7), 10);

  msg_label = gtk_label_new ("");
  gtk_widget_ref (msg_label);
  gtk_object_set_data_full (GTK_OBJECT (msg_dialog), "msg_label", msg_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (msg_label);
  gtk_box_pack_start (GTK_BOX (dialog_vbox7), msg_label, FALSE, FALSE, 0);
  gtk_label_set_line_wrap (GTK_LABEL (msg_label), TRUE);

  dialog_action_area7 = GTK_DIALOG (msg_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (msg_dialog), "dialog_action_area7", dialog_action_area7);
  gtk_widget_show (dialog_action_area7);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area7), 10);

  msg_ok_button = gtk_button_new_with_label (_("OK"));
  gtk_widget_ref (msg_ok_button);
  gtk_object_set_data_full (GTK_OBJECT (msg_dialog), "msg_ok_button", msg_ok_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (msg_ok_button);
  gtk_box_pack_end (GTK_BOX (dialog_action_area7), msg_ok_button, FALSE, TRUE, 0);

  gtk_signal_connect (GTK_OBJECT (msg_ok_button), "clicked",
                      GTK_SIGNAL_FUNC (on_msg_ok_button_clicked),
                      NULL);

  return msg_dialog;
}

