/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "pips.h"

#ifndef N_
#define N_(magic_word)      (magic_word)
#endif

const char *highRanckLabels[] = {
  "hoge hoge",
  N_("I/O"),
  N_("Paper"),
  N_("Layout"),
  N_("Main"),
  N_("Color Management"),
  N_("Utility"),
  NULL
};

const char *ioLabels[] = {
  N_("Input"),
  N_("Output"),
  N_("Select"),
  NULL
};

const char *outputLabels[] = {
  N_("to printer"),
  N_("to file"),
  NULL,
};
  
const char *outputTypeLabels = N_("export file");
  
const char *finishButtonLabels[] = {
  N_("Save"),
  N_("Print"),
  N_("Quit"),
  NULL
};

const char *def_margin_label = N_("Default");
  
OPTION_DATA inkData[] = {
  {     PIPS_OUTPUT_CMYKcm,     "COLOR",        N_("Color")        },
  {     PIPS_OUTPUT_MONO,       "MONO",         N_("Black")        },
  {     END_ARRAY,              "",             ""             }
};
  
OPTION_DATA mediaSizeData[] = {
    { PIPS_PAPER_A4,            "A4",       N_("A4  210x297 mm")                    },
    { PIPS_PAPER_A5,            "A5",       N_("A5 148x210 mm")                     },
    { PIPS_PAPER_A6_INDEX,      "A6",       N_("A6  105x148 mm")                    },
    { PIPS_PAPER_B5,            "B5",       N_("B5  182x257 mm")                    },
    { PIPS_PAPER_LEGAL,         "LGL",      N_("Legal  8 1/2x14 in")                },
    { PIPS_PAPER_LETTER,        "LT",       N_("Letter  8 1/2x11 in")               },
    { PIPS_PAPER_POSTCARD_SNGL, "PC",       N_("Post Card  100x148 mm")             },
    { PIPS_PAPER_PHOTO_PRINT,   "PHOTO",    N_("Photo Paper  4x6 in")               },
    { PIPS_PAPER_POSTCARD_DBL,  "DPC",      N_("Double Post Card  200x148 mm")      },
    { PIPS_PAPER_JENV_CHOU3,    "ENVC3",    N_("Envelope  120x235 mm")              },
    { PIPS_PAPER_JENV_CHOU4,    "ENVC4",    N_("Envelope  90x205 mm")               },
    { PIPS_PAPER_JENV_YOU1,     "ENVY1",    N_("Envelope  120x176 mm")              },
    { PIPS_PAPER_JENV_YOU2,     "ENVY2",    N_("Envelope  114x162 mm")              },
    { PIPS_PAPER_JENV_YOU3,     "ENVY3",    N_("Envelope  98x148 mm")               },
    { PIPS_PAPER_JENV_YOU4,     "ENVY4",    N_("Envelope  105x235 mm")              },
    { PIPS_PAPER_TRIM_4X6,      "4X6",      N_("4x6 100x152 mm")                    },
    { PIPS_PAPER_TRIM_L,        "L",        N_("3.5x5 in  89x127 mm")               },
    { PIPS_PAPER_TRIM_NAMECARD, "NC",       N_("Business Card 89x55 mm")            },
    { PIPS_PAPER_TRIM_2L,        "2L",      N_("5x7 in  127x178 mm")                },
    { PIPS_PAPER_TRIM_LL,        "LL",      N_("3.5x5 in(Landscape)  127x89 mm")    },
    { PIPS_PAPER_A3,            "A3",       N_("A3  297x420 mm")                    },
    { PIPS_PAPER_A3_PLUS,       "A3+",      N_("Super A3 / B  329x483 mm")          },
    { PIPS_PAPER_B4,            "B4",       N_("B4  257x364 mm")                    },
    { PIPS_PAPER_EXECUTIVE,     "EXE",      N_("Executive  7 1/4x10 1/2 in")        },
    { PIPS_PAPER_HALF_LETTER,   "HLT",      N_("Half Letter  5 1/2x8 1/2 in")       },
    { PIPS_PAPER_INDEXCARD5,    "INDEX5",   N_("Index card  5x8 in")                },
    { PIPS_PAPER_INDEXCARD8,    "INDEX8",   N_("Index card  8x10 in")               },
    { PIPS_PAPER_ENV_10,        "ENV10",    N_("Envelope #10  4 1/8x9 1/2")         },
    { PIPS_PAPER_ENV_DL,        "ENVDL",    N_("Envelope DL  110x220 mm")           },
    { PIPS_PAPER_ENV_C6,        "ENVC6",    N_("Envelope C6  114x162 mm")           },
    { PIPS_PAPER_ENV_FOR5X8,    "ENV5X8",   N_("Envelope 132x220 mm")               },
    { PIPS_PAPER_PHOTO_100x150, "PP100",    N_("Photo Paper 100x150 mm")            },
    { PIPS_PAPER_PHOTO_200x300, "PP200",    N_("Photo Paper 200x300 mm")            },
    { PIPS_PAPER_4X6FULL,       "4X6FULL",  N_("4x6 in  No Perforations")           },
    { PIPS_PAPER_PANORAMIC,     "PANORAM",  N_("Panoramic 210x594 mm")              },
    { END_ARRAY,                "",         ""                                      }
};

OPTION_DATA resolutionData[] = {
#if defined(USE_360_DRAFT)
#elif !defined(USE_180_DRAFT)
  {     120,            "120",  N_("120")      },
#else
  {     180,            "180",  N_("180")      },
#endif
#ifdef USE_RESOLUTION_240
  {     240,            "240",  N_("240")      },
#endif
  {     360,            "360",  N_("360")      },
  {     720,            "720",  N_("720")      },
  {     END_ARRAY,      "",     ""         }
};

OPTION_DATA mediaTypeData[] = {
  {     PIPS_MED_PLAIN,         "PLAIN",    N_("Plain Paper")                       },
  {     PIPS_MED_COATED360,     "FINE",     N_("360dpi Ink Jet Paper")              },
  {     PIPS_MED_COATED720,     "SFINE",    N_("Photo Quality Ink Jet Paper")       },
  {     PIPS_MED_NEW_SF,        "SFINE2",   N_("Photo Quality Ink Jet Paper 2")     },
  {     PIPS_MED_GLOSSYPAPER,   "GPAPER",   N_("Photo Paper")                       },
  {     PIPS_MED_ESF,           "ESF",      N_("EPSON Super Fine Paper")            },
  {     PIPS_MED_EPP,           "EPP",      N_("EPSON Glossy Paper")                },
  {     PIPS_MED_IJPC,          "IJPC",     N_("Ink Jet Postcard")                  },
  {     PIPS_MED_GLOSSYFILM,    "GFILM",    N_("Photo Quality Glossy Film")         },
  {     PIPS_MED_TRANSPARENCY,  "OHP",      N_("Ink Jet Transparencies")            },
  {     PIPS_MED_BACKPRINT,     "BLFILM",   N_("Ink Jet Back Light Film")           },
  {     PIPS_MED_IRON_PRINT,    "IRON",     N_("Iron Print Paper")                  },
  {     PIPS_MED_RC_PHOTO,      "PMPHOTO",  N_("Premium Glossy Photo Paper")        },
  {     PIPS_MED_MATT_HEAVY,    "PMMATT",   N_("Matte Paper - Heavyweight")         },
  {     PIPS_MED_CD_R,          "CDR",      N_("CD-R Label")                        },
  {     PIPS_MED_MAT_BOARD,     "MBOARD",   N_("Matte Board Paper")                 },
  {     PIPS_MED_CLPP,          "CLPP",     N_("ColorLife Photo Paper")             },
  {     PIPS_MED_BWIP,          "BWIP",     N_("Bright White Ink Jet Paper")        },
  {     PIPS_MED_DBS_MATTE,     "DBSMATT",  N_("Double-Sided Matte Paper")          },
  {     PIPS_MED_ARCHIVALMATTE, "ARCMATT",  N_("Archival Matte Paper")              },
  {     PIPS_MED_PSEMIGLOSS,    "PSGLOS",   N_("Premium Semigloss Photo Paper")     },
  {     PIPS_MED_PHOTOWEIGHT,   "PHOTOW",   N_("Glossy Paper-Photo Weight")         },
 /* 2003.05.23 Added */
  {     PIPS_MED_GLOSSYPHOTOPAPER,  "GPPAPER",  N_("Glossy Photo Paper")            },
  {     PIPS_MED_RCPC, 	  	    "RCPC",     N_("Recycled Postcard")   	    },
  {     PIPS_MED_MCLP,         "MCLP",          N_("Premium Luster Photo Paper")    },
  {     PIPS_MED_WATERCOLOR,   "WATERCOLOR", N_("Watercolor Paper - Radiant White") },
  /* 2003.09.02 Added */
  {     PIPS_MED_ERC,          "ERC",       N_("EPSON Photo Paper") },

#if	(PM940C) || (PM980C)
  {     PIPS_MED_PLAIN|SILENT_MASK, "PLAIN_SILENT",    N_("Plain Paper (Silent Feed)")   },
  {     PIPS_MED_EPP|SILENT_MASK,   "EPP_SILENT",      N_("EPSON Glossy Paper (Silent Feed)") },
#endif
  
  {     END_ARRAY,              "",         ""                                      }
};

OPTION_DATA microWeaveData[] = {
  {     PIPS_MW_OFF,    "OFF",    ""                },
  {     PIPS_MW_ON,     "ON",     N_("Micro Weave") },
  {     END_ARRAY,      "",       ""                }
};

OPTION_DATA highSpeedData[] = {
  {     PIPS_HS_OFF,    "OFF",  ""                  },
  {     PIPS_HS_ON,     "ON",   N_("High Speed")    },
  {     END_ARRAY,      "",     ""                  }
};

OPTION_DATA colorModeData[] = {
  {     PIPS_CMM_AUTO, "AUTO",          N_("Automatic")                },
  {     PIPS_CMM_PHOTO, "PHOTO",        N_("Photo-realistic")          },
  {     PIPS_CMM_GRAPH, "GRAPH",        N_("Vivid")                    },
  {     PIPS_CMM_NONE,  "NONE",         N_("No Color Adjustment")      },
  {     END_ARRAY,      "",             ""                             }
};
  
OPTION_DATA halftoneData[] = {
  {     PIPS_HT_QUALITY,        "ED",   N_("High Quality Halftoning")    },
  {     PIPS_HT_SPEED,          "DB",   N_("High Speed Halftoning")      },
  {     PIPS_HT_NONE,           "NONE", N_("No Halftoning")              },
  {     END_ARRAY,              "",     ""                               }
};
  
OPTION_DATA binData[] = {
  {     PIPS_BIN_AUTO,          "AUTO",     N_("Auto Sheet Feeder")          },
  {     PIPS_BIN_USER,          "ROLL",     N_("Roll Paper")                 },
  {     PIPS_BIN_TRIMBANNER,    "TROLL",    N_("Roll Paper (Banner)")        },
  {     PIPS_BIN_AUTO_TRIM,     "TAUTO",    N_("Sheet Feeder (Banner)")      },
  {     PIPS_BIN_AUTO_TRIM_4,   "T4AUTO",   N_("Sheet Feeder-No Margins"),   },
  {     PIPS_BIN_AUTO_EX,       "EXAUTO",   N_("Sheet Feeder-Area Maximum")  },
  {     END_ARRAY,              "",         ""                               }
    
};

OPTION_DATA levelData[] = {
#if (!HIGH_RESOLUTION) 
  {     PIPS_LV_DRAFT,          "DRAFT",        N_("Draft")           },
  {     PIPS_LV_STD,            "STD",          N_("Standard")        },
  {     PIPS_LV_FINE,           "FINE",         N_("Fine")            },
  {     PIPS_LV_SFINE,          "SFINE",        N_("Super Fine")      },
  {     PIPS_LV_PHOTO,          "PHOTO",        N_("Photo")           },
  {     PIPS_LV_SPHOTO,         "SPHOTO",       N_("Super Photo")     },
#else
  /*  */
  {     PIPS_LV_DRAFT,          "DRAFT",        N_("Draft")           },
  {     PIPS_LV_STD360,         "STD360",       N_("STD  (360dpi)")        },
  {     PIPS_LV_FINE720,        "FINE720",      N_("Fine (720dpi)")        },
  {     PIPS_LV_SFINE720,       "SFINE720",     N_("Super Fine (720dpi)") },
  {     PIPS_LV_PHOTO1440,      "PHOTO1440",    N_("Photo (1440dpi)")     },
  {     PIPS_LV_PHOTO2880,      "PHOTO2880",    N_("Photo (2880dpi)")     },
  {     PIPS_LV_SPHOTO2880,     "SPHOTO2880",   N_("Super Photo (2880dpi)") },
#endif

/* 2003.05.23 Added */
  {	PIPS_LV_SILENT,		"SILENT", 	N_("Standard(Silent)")    },
  {     END_ARRAY,              "",             ""                    }
};

OPTION_DATA fitPageData[] = {
  {     PIPS_FP_OFF,    "OFF",  ""                  },
  {     PIPS_FP_ON,     "ON",   N_("Fit to Page")   },
  {     END_ARRAY,      "",     ""                  }
};

OPTION_DATA multiPageData[] = {
  {     PIPS_MP_1,          "1",        N_("Normal")      },
  {     PIPS_MP_2,          "2",        N_("2 Pages")     },
  {     PIPS_MP_4,          "4",        N_("4 Pages")     },
  {     END_ARRAY,      "",     ""                  }
};

/* DEFAULT  */
OPTION_DATA inksetData[] = {
  {     PIPS_INKSET_CMYK,       "CMYK",           ""        },
  {     PIPS_INKSET_CMYKcm,     "CMYKcm",         ""        },
  {     PIPS_INKSET_CMYKcmDY,   "CMYKcmDY",       ""        },
  {     PIPS_INKSET_CMYKcmLk,   "CMYKcmLk",       ""        },
  {     PIPS_INKSET_CMYcmMkLk,  "CMYcmMkLk",      ""        },
  {     PIPS_INKSET_CMYcmMk,    "CMYcmMk",        ""        },
  {     END_ARRAY,              "",        ""            }
};

OPTION_DATA autoCutData[] = {
  {     PIPS_CP_NONE,       "NONE",     N_("Not Cut")   },
  {     PIPS_CP_1,          "1",        N_("1 Cut")     },
  {     PIPS_CP_2,          "2",        N_("2 Cut")     },
  {     END_ARRAY,      "",     ""                  }
};

OPTION_ALL opt_all[] = {
  {     P_SCALE,                NULL,           N_("Reduce/Enlarge (%)")    },
  {     P_INK,                  inkData,        N_("Ink")                   },
  {     P_MEDIA_SIZE,           mediaSizeData,  N_("Paper Size")            },
  {     P_RESOLUTION,           resolutionData, N_("Input Resolution")      },
  {     P_MEDIA_TYPE,           mediaTypeData,  N_("Media Type")            },
  {     P_COLOR_MODE,           colorModeData,  N_("Mode")                  },
  {     P_BRIGHTNESS,           NULL,           N_("Brightness")            },
  {     P_CONTRAST,             NULL,           N_("Contrast")              },
  {     P_SATURATION,           NULL,           N_("Saturation")            },
  {     P_STRENGTH,             NULL,           ""                          },
  {     P_HALF_TONE,            halftoneData,   N_("Halftone")              },
  {     P_MICRO_WEAVE,          microWeaveData, N_("Micro Weave")           },
  {     P_HIGH_SPEED,           highSpeedData,  N_("High Speed")            },
  {     P_QUALITY_LEVEL,        levelData,      N_("Quality")               },
  {     P_MARGIN,               NULL,           N_("Margin (mm)")           },
  {     P_FIT_PAGE,             fitPageData,    N_("Fit to Page")           },
  {     P_MULTI_PAGE,           multiPageData,  N_("Multi Page")            },
  {     P_BIN,                  binData,        N_("Paper Source")          },
  {     P_AUTO_CUT,             autoCutData,    N_("Auto Cut")              },
  {     P_STRENGTH_CYAN,        NULL,           N_("Cyan")                  },
  {     P_STRENGTH_MAGENTA,     NULL,           N_("Magenta")               },
  {     P_STRENGTH_YELLOW,      NULL,           N_("Yellow")                },
  {     P_MARGIN_X,             NULL,           N_("Left")                  },
  {     P_MARGIN_Y,             NULL,           N_("Top")                   },
  {     P_INKSET,               inksetData,     ""                          },
  {     END_ARRAY,              NULL,           ""                          }
};

const char Status_Monitor[] = N_("Status Monitor");
const char Nozzle_Check[] = N_("Nozzle Check");
const char Head_Cleaning[] = N_("Head Cleaning");
const char Print_Head_Alignment[] = N_("Print Head Alignment");
const char Auto_Cutter_Adjustment[] = N_("Auto Cutter Adjustment");
const char Ink_Black[] = N_("Black");
const char Ink_Color[] = N_("Color");
const char Ink_Chenge[] = N_("Replacement");
const char Ink_Volume[] = N_("Ink");
const char No_Connect_Message[] = N_("Cannot communicate with a printer.");

const char Nozzle_Check_Err_Msg[] = N_("Nozzle Check can not be completed because ink is low or out.");
const char Head_Cleaning_Err_Msg[] = N_("Head Cleaning can not be completed because ink is low or out.");
const char Head_Alignment_Err_Msg[] = N_("Print Head Alignment can not be completed because ink is low or out.");
const char Utility_Err_Msg[] = N_("A problem has occurred.");

const char Ink_Change[] = N_("InkChange");
const char Ink_Change_Msg[] = N_("The ink cartridge configuration was changed.\n"
				 "Settings will be reset to the default.\n"
				 "Reconfigure the settings as needed.");
