/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2003-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __OPT_RSC__
#define __OPT_RSC__

#include "pipsDef.h"


/* Inset Defult */
#define	PIPS_INKSET_DEFAULT PIPS_INKSET_CMYKcmLk

#ifndef	_ONLY_NEED_DEFAULT_

/* Option Entry */
char *inkEntry[] = {
        "COLOR", "MONO",
        NULL
};

char *binEntry[] = {
        "AUTO", "ROLL", "TROLL", "T4AUTO",
        NULL
};

/* ASF */
char *mediaSizeEntry[] = {
	"A4",     "A5",    "A3",    "A3+",    "B5",     "B4",
        "LT",     "LGL",   "A6",    "INDEX5", "INDEX8", "ENV10", 
        "ENVDL",  "ENVC6", "ENV5X8",
	"4X6FULL","PP100", "L",     "2L", 
        NULL
};

/* ROLL */
char *mediaSizeEntry_R[] = {
	"A4",     "A5",    "A3",    "A3+",    "B5",     "B4",
        "LT",     "LGL",   "A6",    "INDEX5", "INDEX8",  
	"4X6",    "PP100", "L",     "2L", 
        NULL
};

/* ROLL-Banner */
char *mediaSizeEntry_TR[] = {
	"A4",     "A3",    "A3+",
	"4X6","PP100", "LL", "L", "2L", "NC",
        NULL
};

/* ASF-No Margin  */
char *mediaSizeEntry_NMA[] = {
	"A4",     "A3",    "A3+",
        "LT",     "INDEX5","INDEX8", 
	"4X6FULL","PP100", "L", "2L", 
        NULL
};

char *resolutionEntry[] = {
        "360", "720",
        NULL
};

/* Caution:				*/
/* PPI+LK -> cannot use PSGLOS,PHOTOW	*/
char *mediaTypeEntry[] = {
        "PLAIN",  "ARCMATT",  "PSGLOS", "PHOTOW", "WATERCOLOR",
        NULL
};

char *colorModeEntry[] = {
       "AUTO", "PHOTO", "GRAPH", "NONE",
        NULL
};

char *halftoneEntry[] = {
        "ED",
        NULL
};

char *levelEntry[] = {
        "DRAFT", "STD", "FINE", "SFINE", "PHOTO", "SPHOTO",
        NULL
};

char *multiPageEntry[] = {
        "1", "2", "4",
        NULL
};

char *autoCutEntry[] = {
        "NONE",
        NULL
};


/* pModeCol     :       Color
   pModeMono    :       Monochrome

   MediaNumber  :       see pipsDef.h
   Input        :       1:120/180, 2:360, 4:720
   Halftone     :       <or> 1:ED 2:DB
   HighSpeed    :       0:OFF 1:ON 2:ON/OFF
   Quality      :       0xXXX
                          ||+---- at Input 1
                          |+----- at Input 2
                          +------ at Input 4

*/
short pModeCol[] = {
        /* mediaName            Input           MicroWeave      Inkset */
        /* & MediaNumber                Halftone        HighSpeed                     Quality */
        /* PLAIN */
        PIPS_MED_PLAIN,         2,      1,      0,      1,      0,                    0x0A0,
        PIPS_MED_PLAIN,         2,      1,      0,      1,      0,                    0x010,
        PIPS_MED_PLAIN,         2,      1,      1,      2,      0,                    0x010,
        PIPS_MED_PLAIN,         6,      1,      1,      2,      0,                    0x330,
        /* ARCHMATT */
        PIPS_MED_ARCHIVALMATTE,	6,      1,      1,      2,      0,                    0x330,
        PIPS_MED_ARCHIVALMATTE,	4,      1,      1,      2,      0,                    0x400,
        PIPS_MED_ARCHIVALMATTE, 4,      1,      1,      2,      PIPS_INKSET_CMYcmMkLk,0x500,
        /* PSGLOS */
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x400,
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x500,
        /* PHOTOW */
        PIPS_MED_PHOTOWEIGHT,   6,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x330,
        PIPS_MED_PHOTOWEIGHT,   4,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x400,
        PIPS_MED_PHOTOWEIGHT,   4,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x500,
        /* WATERCOLOR */
        PIPS_MED_WATERCOLOR,  	6,      1,      1,      2,      0,                    0x330,
        PIPS_MED_WATERCOLOR,  	4,      1,      1,      2,      0,                    0x400,
        PIPS_MED_WATERCOLOR,  	4,      1,      1,      2,      PIPS_INKSET_CMYcmMkLk,0x500,
	-1
};

short pModeMono[] = {
        /* mediaName            Input           MicroWeave      Quality */
        /* & MediaNumber                Halftone        HighSpeed       */
        /* PLAIN */
        PIPS_MED_PLAIN,         2,      1,      0,      1,      0,                    0x0A0,
        PIPS_MED_PLAIN,         2,      1,      0,      1,      0,                    0x010,
        PIPS_MED_PLAIN,         2,      1,      1,      2,      0,                    0x010,
        PIPS_MED_PLAIN,         6,      1,      1,      2,      0,                    0x330,
        /* ARCHMATT */
        PIPS_MED_ARCHIVALMATTE,	6,      1,      1,      2,      0,                    0x330,
        PIPS_MED_ARCHIVALMATTE,	4,      1,      1,      2,      0,                    0x400,
        PIPS_MED_ARCHIVALMATTE, 4,      1,      1,      2,      PIPS_INKSET_CMYcmMkLk,0x500,
        /* PSGLOS */
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x400,
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x500,
        /* PHOTOW */
        PIPS_MED_PHOTOWEIGHT,   6,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x330,
        PIPS_MED_PHOTOWEIGHT,   4,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x400,
        PIPS_MED_PHOTOWEIGHT,   4,      1,      1,      2,      PIPS_INKSET_CMYKcmLk, 0x500,
        /* WATERCOLOR */
        PIPS_MED_WATERCOLOR,  	6,      1,      1,      2,      0,                    0x330,
        PIPS_MED_WATERCOLOR,  	4,      1,      1,      2,      0,                    0x400,
        PIPS_MED_WATERCOLOR,  	4,      1,      1,      2,      PIPS_INKSET_CMYcmMkLk,0x500,
	-1
};

/* Bin="T4AUTO" ̵ˤʤ⡼ID (color,black )   */
/* t4ΤȤ_for_<̾>򳰤				*/ 
short de_param_mode_t4[] = {
	0, 1 , -1
};

#endif /* _ONLY_NEED_DEFAULT_ */

#endif /* __OPT_RSC__ */
