/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `dtrfilter' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission
 * to link the code of this program with the `dtr' library and
 * distribute linked combinations including the two.  You must obey
 * the GNU General Public License in all respects for all of the
 * code used other then `dtr'.
 */
#ifndef PF_PNG_H
#define PF_PNG_H
#include <png.h>

typedef png_uint_32 (lib_png_access_version_number)  (void);
typedef png_infop   (lib_png_create_info_struct)     (png_structp);
typedef png_structp (lib_png_create_read_struct)     (png_const_charp, png_voidp, png_error_ptr, png_error_ptr);
typedef void        (lib_png_destroy_read_struct)    (png_structpp, png_infopp, png_infopp);
typedef png_uint_32 (lib_png_get_IHDR)               (png_structp, png_infop, png_uint_32 *, png_uint_32 *, int *, int *, int *, int *, int *);
typedef png_uint_32 (lib_png_get_valid)              (png_structp, png_infop, png_uint_32);
typedef void        (lib_png_init_io)                (png_structp, FILE *);
typedef void        (lib_png_read_end)               (png_structp, png_infop info_ptr);
typedef void        (lib_png_read_info)              (png_structp, png_infop);
typedef void        (lib_png_read_rows)              (png_structp, png_bytepp, png_bytepp, png_uint_32);
typedef void        (lib_png_read_update_info)       (png_structp, png_infop);
typedef void        (lib_png_set_expand)             (png_structp);
typedef void        (lib_png_set_gray_to_rgb)        (png_structp);
typedef int         (lib_png_set_interlace_handling) (png_structp);
typedef void        (lib_png_set_packing)            (png_structp);
typedef void        (lib_png_set_rgb_to_gray)        (png_structp, int, double, double);
typedef void        (lib_png_set_sig_bytes)          (png_structp, int);
typedef void        (lib_png_set_strip_16)           (png_structp);
typedef void        (lib_png_set_strip_alpha)        (png_structp);
typedef int         (lib_png_sig_cmp)                (png_bytep, png_size_t, png_size_t);

#endif /* PF_PNG_H */
