/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "paper.h"
#include "paper.rsc"

LP_PAPER_CONF
call_paper_conf (char* bin, char*paper)
{
  int i;
  LP_PAPER_CONF lp_pconf = NULL;

  if (bin == NULL || !strcmp (bin, "") || !strcmp (bin, "AUTO"))
    lp_pconf = paper_auto;

  else if (!strcmp (bin, "ROLL"))
    lp_pconf = paper_roll;

  else if (!strcmp (bin, "TROLL")
	   || !strcmp (bin, "TR3300")
	   || !strcmp (bin, "TR820"))
    lp_pconf = paper_roll_trim;

  else if (!strcmp (bin, "TAUTO"))
    lp_pconf = paper_auto_trim;

  else if (!strcmp (bin, "T4AUTO"))
    lp_pconf = paper_auto_trim_4;

#if (PMG800)
  else if (!strcmp (bin, "MANUAL"))
    lp_pconf = paper_manual;

  else if (!strcmp (bin, "TMANUAL"))
    lp_pconf = paper_manual_trim;

#endif

  if (lp_pconf == NULL)
    return NULL;

  for (i = 0; lp_pconf[i].res != NULL; i++)
    {
      if (!strcmp (lp_pconf[i].res, paper))
	return &(lp_pconf[i]);
    }

  return NULL;
}

long
round_off (double val)
{
  long low, high;

  low = (long)val;
  high = (long)(val + 0.5);

  return (low == high) ? low : high;
}
