/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pipsdef.h"
#include "pfatt.h"

typedef struct
{
	int check;
	char *path;
	FILE *fp;
	long width_byte;
	POINT size;
	POINT out_size;
	POINT out_margin;
	unsigned char *data;
	unsigned char *out_data;
	long data_count;
	long out_count;
} ATBMP_STRUCT, *P_ATBMP_STRUCT;

#pragma pack(1)
typedef struct
{
	char head[14];
	unsigned long width_byte;
	unsigned long width;
	unsigned long height;
} ATBMP_HEADER, *P_ATBMP_HEADER;
#pragma pack()

static const char head_string[] = "PIPS_Attribute";
static ATBMP_STRUCT atbmp_;

int
atbmp_init (unsigned char *path)
{
	FILE *fp;

	atbmp_.check = 0;

	if (!path) return 1;
	atbmp_.path = path;
	
	fp = fopen (path, "rb");
	if (!fp)
	{
		atbmp_end ();
		return 1;
	}
	atbmp_.fp = fp;
	atbmp_.check ++;

	return 0;
}

int
atbmp_page_init (long width, long height)
{
	FILE *fp = atbmp_.fp;
	ATBMP_HEADER header;

	if (!atbmp_.check) return 1;

	if ((fread (&header, sizeof (ATBMP_HEADER), 1, fp)) != 1) return 1;

	if (memcmp (header.head, head_string, strlen (head_string))) return 1;

	atbmp_.data = (unsigned char*) calloc (header.width_byte, sizeof (unsigned char));
	atbmp_.out_data = (unsigned char*) calloc (width, sizeof (unsigned char));
	if (!atbmp_.data || !atbmp_.out_data) return 1;

	atbmp_.width_byte = header.width_byte;
	atbmp_.size.x = header.width;
	atbmp_.size.y = header.height;
	atbmp_.data_count = 0;
	atbmp_.out_count = 0;
	atbmp_.out_size.x = width;
	atbmp_.out_size.y = height;

	return 0;
}


unsigned char *
atbmp_read_attribute (void)
{
	FILE *fp = atbmp_.fp;
	unsigned char *data = atbmp_.data;
	unsigned char *out_data = atbmp_.out_data;
	long i, wcount = 1;
	
	if (!atbmp_.check || atbmp_.data_count > atbmp_.size.y) return NULL;
	
	if (((atbmp_.data_count * atbmp_.out_size.y / atbmp_.size.y) <= atbmp_.out_count)
	    || atbmp_.out_count == 0)
	{
		if ((fread (data, atbmp_.width_byte, 1, fp)) != 1) return NULL;
		
		for (i = 1; i <= atbmp_.out_size.x; i ++)
		{
			if ((wcount * atbmp_.out_size.x / atbmp_.size.x) <= i)
				wcount ++;
			
			out_data[i - 1] = data[wcount - 1];
		}
		
		atbmp_.data_count ++;
	}
	
	atbmp_.out_count ++;
	return out_data;
}


void
atbmp_end (void)
{
	if (atbmp_.data) free (atbmp_.data);
	if (atbmp_.out_data) free (atbmp_.out_data);
	if (atbmp_.fp) fclose (atbmp_.fp);
	
	atbmp_.check = 0;
	return;
}

int
atbmp_seek (void)
{
	int i;
	long num;

	num = atbmp_.size.y - atbmp_.data_count;

	for (i = 0; i < num; i ++)
		if ((fread (atbmp_.data, atbmp_.width_byte, 1, atbmp_.fp)) != 1) return 1;

	return 0;
}

int atbmp_check (void) { return atbmp_.check; }
