/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include "getstat.h"
#include "ekpcom.h"

int
get_status (char *buf)
{
	char status_command[]  = { 's', 't', 0x01, 0x00, 0x01 };
	int nwrite, nread;

	buf[0] = '\0';

	nwrite = sizeof (status_command);
	nread = 0;
	if (sock_write (status_command, &nwrite) < 0)
	{
		sock_reopen ();
		nwrite = sizeof (status_command);
		sock_write (status_command, &nwrite);
	}
	
	if (nwrite > 0)
	{
		nread = REPLAY_SIZE;
		sock_read (buf, &nread);
		buf[nread] = '\0';
	}

	if (buf[0]) /* no error */
		return 0;
	/* error */
	return 1;
}

int
get_inkset (void)
{
	char buf[REPLAY_SIZE];
	char* point;
	int c, m, y, k, lc, lm, dy, lk, mk;
	char ic[7] = "0x";

	c = m = y = k = lc = lm = dy = lk = mk = 0;
	get_status (buf);
	
	point = strstr (buf, "INK:");

	if (point == NULL) {
		return PIPS_INKSET_DEFAULT;
	}

	point += 4;	/* skip "INK:" */
	while (*point != ';') {
		memcpy(ic + 2, point, 4);
		*(ic + 6) = '\0';
		switch (strtol(ic, (char **)NULL, 16)) {
		case 0x1101:
		case 0x1140:
			k++; break;
		case 0x3202:
			c++; break;
		case 0x4304:
			m++; break;
		case 0x5408:
			y++; break;
		case 0x6210:
			lc++; break;
		case 0x7320:
			lm++; break;
		case 0x9440:
			dy++; break;
		case 0xA140:
			lk++; break;
		case 0xB140:
		case 0xB101:
			mk++; break;
		default:
			return PIPS_INKSET_DEFAULT;
			break;
		}
		point += 4;
		if( point >= (buf+REPLAY_SIZE) ){
		  break;
		}
		if( *point == ',' ) point++;
	}
	
	if (dy) {
		return PIPS_INKSET_CMYKcmDY;
	} else if (k && lk) {
		return PIPS_INKSET_CMYKcmLk;
	} else if (mk && !k) {
		if (lk) {
			return PIPS_INKSET_CMYcmMkLk;
		} else {
			return PIPS_INKSET_CMYcmMk;
		}
	} else if (lc && lm) {
		return PIPS_INKSET_CMYKcm;
	} else {
		return PIPS_INKSET_CMYK;
	}

	/* error */
	return PIPS_INKSET_DEFAULT;
};
