/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __PAPER_RSC__
#define __PAPER_RSC__

#include <string.h>
#include "paper.h"
#define LIST_END { NULL, -1, -1, -1, -1, -1, -1 }

/* üޡ󥵥13mmб Stylus Photo R200/R210 SeriesѻΤб */
/* ϥE̤бΤE̵E*/

/* ASF */
PAPER_CONF paper_auto[] = {
/* A4 210 x 297 mm */                    { "A4",      2976,   4209,   2892,   3884,   42,     42 },
/* B5 182 x 257 mm */                    { "B5",      2580,   3643,   2496,   3318,   42,     42 },
/* A5 148 x 210 mm */                    { "A5",      2098,   2976,   2014,   2651,   42,     42 },
/* Letter 8 1/2 x 11 in */               { "LT",      3060,   3960,   2976,   3635,   42,     42 },
/* Legal 8 1/2 x 14 in */                { "LGL",     3060,   5040,   2976,   4715,   42,     42 },
/* Executive 7 1/4 x 10 1/2 in */        { "EXE",     2610,   3780,   2526,   3455,   42,     42 },
/* Half Letter 5 1/2 x 8 1/2 in */       { "HLT",     1980,   3060,   1896,   2735,   42,     42 },
/* A6 Index card 105 x 148 mm */         { "A6",      1488,   2098,   1404,   1773,   42,     42 },
/* Index Card 5 x 8 in */                { "INDEX5",  1800,   2880,   1716,   2555,   42,     42 },
/* Index Card 8 x 10 in */               { "INDEX8",  2880,   3600,   2796,   3275,   42,     42 },
/* Envelope #10 4 1/8 x 9 1/2 in */      { "ENV10",   1485,   3420,   1401,   3095,   42,     42 },
/* Envelope DL 110 x 220 mm */           { "ENVDL",   1559,   3118,   1475,   2793,   42,     42 },
/* Envelope C6 114 x 162 mm */           { "ENVC6",   1616,   2296,   1532,   1971,   42,     42 },
/* Envelope 132 x 220 mm */              { "ENV5X8",  1871,   3118,   1787,   2793,   42,     42 },
/* Photo Paper 4 x 6 in No Perforations*/{ "4X6FULL", 1440,   2160,   1356,   1835,   42,     42 },
/* 10 x 15 cm Photo */                   { "PP100",   1417,   2125,   1333,   1800,   42,     42 },
/* 20 x 30 cm Photo */                   { "PP200",   3061,   4790,   2976,   4309,   42,     198 },
/* 3.5 x 5 in (9 x 13 cm) */             { "L",       1261,   1800,   1177,   1475,   42,     42 },
/* 5 x 7 in (13 x 18 cm) */              { "2L",      1800,   2522,   1716,   2197,   42,     42 },
/* Panoramic 210 x 594 mm */             { "PANORAM", 2976,   8419,   2892,   8094,   42,     42 },
                                         LIST_END
};

/* Roll */
PAPER_CONF paper_roll[] = {
                                         LIST_END
};

/* Roll (trim) */
PAPER_CONF paper_roll_trim[] = {
                                         LIST_END
};

/* ASF (trim) */
PAPER_CONF paper_auto_trim[] = {
                                         LIST_END
};

/*  ASF (No Margin) */
PAPER_CONF paper_auto_trim_4[] = {
/* A4 210 x 297 mm */                    { "A4",      2976,   4209,   3047,   4322,    0,      0 },
/* Index Card 5 x 8 in */                { "INDEX5",  1800,   2880,   1871,   2993,    0,      0 },
/* Photo Paper 4 x 6 in No Perforations*/{ "4X6FULL", 1440,   2160,   1511,   2273,    0,      0 },
/* 10 x 15 cm Photo */                   { "PP100",   1417,   2125,   1488,   2238,    0,      0 },
/* 3.5 x 5 in (9 x 13 cm) */             { "L",       1261,   1800,   1332,   1913,    0,      0 },
/* 5 x 7 in (13 x 18 cm) */              { "2L",      1800,   2522,   1871,   2635,    0,      0 },
/* Panoramic 210 x 594 mm */             { "PANORAM", 2976,   8419,   3047,   8532,    0,      0 },
                                         LIST_END
};

#endif /* __PAPER_RSC__ */
