/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __UI_H__
#define __UI_H__

#include <stdio.h>
#include <stdlib.h>
#include "pipsDef.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
	
#define END_ARRAY -1
			// 2003.11.05
#define ENTRY_MAX 48	// 30 -> 48 ѻäˤȤʤ48˹
	
#define N_OPT 19
#define EX_N_OPT 31
	
	/* option's ID */
#define P_SCALE            0
#define P_INK              1
#define P_MEDIA_SIZE       2
#define P_RESOLUTION       3
#define P_MEDIA_TYPE       4
#define P_COLOR_MODE       5
#define P_BRIGHTNESS       6
#define P_CONTRAST         7
#define P_SATURATION       8
#define P_STRENGTH         9
#define P_HALF_TONE        10
#define P_MICRO_WEAVE      11   /* add Wed Dec  5 2001 s.kitayama */
#define P_HIGH_SPEED       12
#define P_QUALITY_LEVEL    13
#define P_MARGIN           14   /* add Mon Aug 28 2000 sk */
#define P_FIT_PAGE         15   /* add Tue Oct  2 2001 sk */
#define P_MULTI_PAGE       16   /* add Tue Oct  2 2001 sk */
#define P_BIN              17   /* chenge Mon Aug 28 2000 sk */
#define P_AUTO_CUT        18   /* add Wed Apr  3 2002 sk */

#define P_STRENGTH_CYAN    20
#define P_STRENGTH_MAGENTA 21
#define P_STRENGTH_YELLOW  22
#define P_MARGIN_X         23
#define P_MARGIN_Y         24
#define P_INKSET           25   /* add Fri Feb  1 2002 sk */

#define P_OUTPUT_EX        30

	/* label call type    -chenged Mon Aug 28 2000 sk */
	enum nBASE_CALL_TYPE
	{
		CALL_FOR_RSC_NAME = 0,
		CALL_FOR_X_NAME,
		CALL_FOR_VALUE
	};

#define WIDTHBYTES(bits)      (((bits) + 31) / 32 * 4)

	typedef struct tagPIPS_INIT_PARAM
	{
		int action_mode;
		char* atbmp_fifo_path;
	} PIPS_INIT_PARAM;

	typedef struct tagSEP_INIT_PARAM
	{
		short paper_id;
		int prt_format;
		POINT src_resolution;
		int media_type;
		int high_speed;
		int bin_id;
		int color_correction;
		int halftone_type;
		int brightness;
		int contrast;
		int saturation;
		int r_strength;
		int g_strength;
		int b_strength;
		int mag;
		int qlevel;
#ifdef CONV_VERSION2
		POINT margin;		/* add Mon Aug 28 2000 sk */
#endif /* CONV_VERSION2 */
		int fit_page;
		int multi_page;
		int mw_type;
		int inkset;
		int auto_cut;
	} SEP_INIT_PARAM;
  
	typedef struct _OPTION_DATA
	{
		int value;
		char *rsc_name;
		char *x_name;
		char *x_name_jp;
	} OPTION_DATA;

	typedef struct _OPTION_ALL
	{
		int id;
		OPTION_DATA *data;
		char *x_name;
		char *x_name_jp;    
	} OPTION_ALL;

	int xMode (int, char*[], char*, SEP_INIT_PARAM*, PIPS_INIT_PARAM*);
	int cMode (char *, SEP_INIT_PARAM *, PIPS_INIT_PARAM *);
	int printLoop (char*, FILE*, SEP_INIT_PARAM*);
	OPTION_DATA* databasesCall (int, int, void*);
	int printModeCheck (const short*, int, SEP_INIT_PARAM*);
	int getValueOfDatabases (int, char*);
	char* getRscName (int, int);
  
	int getRsc (SEP_INIT_PARAM*);
	void saveRsc (void*[]);
	int getOpts (int, char*[], char **, SEP_INIT_PARAM *, PIPS_INIT_PARAM *pip);
	int getOptsForX (void*[], SEP_INIT_PARAM*);
	int fileLoad (FILE*, FILE*, POINT*, UCHAR**);
	void confWinInit (int*, char**[], char*, SEP_INIT_PARAM*, PIPS_INIT_PARAM*);
	void confWinFinalize (void);
	int confWinShow (SEP_INIT_PARAM*, const char*);

#ifdef CONV_VERSION2
	int
	graphics_converter_version2 (SEP_INIT_PARAM *, char*, char*, char*);
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __UI_H__ */
