/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `dtrfilter' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission
 * to link the code of this program with the `dtr' library and
 * distribute linked combinations including the two.  You must obey
 * the GNU General Public License in all respects for all of the
 * code used other then `dtr'.
 */
#include <stdio.h>
#include <stdlib.h>
#include "pfpng_ext.h"
#include "defs.h"
#include "img.h"

typedef struct {
	FILE* fp;
	u_int width;
	u_int height;
	png_structp png_ptr;
	png_infop info_ptr;
} img_stat, *p_img_stat;

/* pngformatbufferΥ */
#define PNG_CHECK_NUMBER 8

void*
img_init (FILE* fp)
{
	p_img_stat p_img;

	char header[PNG_CHECK_NUMBER];
	int bit_depth, color_type;

	png_uint_32 ver;
	char version [32];
	png_uint_32 width, height;
	png_structp png_ptr;
	png_infop info_ptr;


	p_img = (p_img_stat)calloc (1, sizeof (img_stat));
	if (!p_img) return 0;

	/* Dynamic linking to PNG library. */
	if (!open_png_library ())
		return 0;

	ver = dl_png_access_version_number ( );
	
	sprintf ( version, "%ld.%ld.%ld",
		  ver / 10000,
		  ( ver / 100 )  % 100,
		  ver % 100 );

	fread (header, PNG_CHECK_NUMBER, 1, fp);
	if (dl_png_sig_cmp (header, (png_size_t)0, PNG_CHECK_NUMBER))
		return 0;

	png_ptr = dl_png_create_read_struct (version, NULL, NULL, NULL);
	info_ptr = dl_png_create_info_struct (png_ptr);
	if (!png_ptr || !info_ptr)
		return 0;

	/* libpngǥ顼äΰ٤setjmp */
	if (setjmp (png_ptr->jmpbuf))
		return 0;

	/* I/O */
	dl_png_init_io (png_ptr, fp);
	/* ɤ߹ʬ򶵤 */
	dl_png_set_sig_bytes (png_ptr, PNG_CHECK_NUMBER);
	/* pngξ */
	dl_png_read_info (png_ptr, info_ptr);
	/* IHDRɤ߹ */
	dl_png_get_IHDR (png_ptr, info_ptr, &width, &height, &bit_depth, &color_type, NULL, NULL, NULL);

	/* ǡ8bitꤹ */
	if ((color_type == PNG_COLOR_TYPE_PALETTE && bit_depth <= 8)
	    || (color_type == PNG_COLOR_TYPE_GRAY && bit_depth < 8)
	    || (dl_png_get_valid (png_ptr, info_ptr, PNG_INFO_tRNS)))
		dl_png_set_expand (png_ptr);
	if (bit_depth < 8) dl_png_set_packing (png_ptr);
	if (bit_depth == 16) dl_png_set_strip_16 (png_ptr);
	if (color_type == PNG_COLOR_TYPE_RGB_ALPHA) dl_png_set_strip_alpha(png_ptr);

	/* 3byteBGRꤹ */
	if (color_type == PNG_COLOR_TYPE_GRAY
	    || color_type == PNG_COLOR_TYPE_GRAY_ALPHA
	    || color_type == PNG_COLOR_TYPE_PALETTE)
		dl_png_set_gray_to_rgb (png_ptr);
  
	dl_png_read_update_info (png_ptr, info_ptr);

	p_img->fp = fp;
	p_img->width = (unsigned int)width;
	p_img->height = (unsigned int)height;
	p_img->png_ptr = png_ptr;
	p_img->info_ptr = info_ptr;

	return (void*)p_img;
}

void
img_end (void* handle)
{
	p_img_stat p_img = (p_img_stat)handle;
	if (p_img->png_ptr && p_img->info_ptr)
	{
		dl_png_read_end(p_img->png_ptr, p_img->info_ptr);
		dl_png_destroy_read_struct(&p_img->png_ptr, &p_img->info_ptr, (png_infopp)NULL);
		p_img->png_ptr = NULL;
		p_img->info_ptr = NULL;

		close_png_library ();
	}
	return;
}

u_int
img_get_width (void* handle)
{
	p_img_stat p_img = (p_img_stat)handle;
	return p_img->width;
}

u_int
img_get_height (void* handle)
{
	p_img_stat p_img = (p_img_stat)handle;
	return p_img->height;
}

void
img_get_image (void* handle, u_int width_bytes, u_char* buf)
{
	p_img_stat p_img = (p_img_stat)handle;
	int i, j, height, pass;
	/* 2004.03.02 Add */
	png_bytep p;

	height = img_get_height (handle);
	pass = dl_png_set_interlace_handling(p_img->png_ptr);

	for (j = 0; j < pass; j++)
	{
		for (i = 0; i < height; i++)
		{
			/* 2004.03.02 Add */
			p = (png_bytep)(buf + width_bytes * i);
			dl_png_read_rows (p_img->png_ptr, (png_bytepp)&p, NULL, 1);
		}
	}
	return;
}
