# Copyright (C) SEIKO EPSON CORPORATION 2004.

%define PREFIX /usr
%define BINDIR %{PREFIX}/bin
%define ETCDIR /etc
%define VARDIR /var
%define LIBDIR %{PREFIX}/lib
%define KOWADIR %{PREFIX}/local/EPKowa
%define DEAMONDIR %{KOWADIR}/printer
%define DATADIR %{KOWADIR}/SPR800
%define LOCALEDIR %{PREFIX}/share/locale

%define CUPS_SERVER_DIR %{PREFIX}/lib/cups
%define CUPS_DATA_DIR %{PREFIX}/share/cups

Summary: Photo Image Print System for EPSON Stylus Photo R800 (i386)
Summary(ja): EPSON Stylus Photo R800 ѤPhoto Image Print System (i386)
Name: pips-spr800
Version: 2.6.2
Release: 2
Copyright: Copyright (C) 2000-2004 EPSON KOWA Corporation. / Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
Group: System/Printer
Source0: %{name}-%{version}.tar.gz
Packager: EPSON KOWA Corporation
Vendor: EPSON KOWA Corporation <http://www.epkowa.co.jp/>
BuildRoot: /var/tmp/%{name}-%{version}

%description

%prep
[ "${RPM_BUILD_ROOT}" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%setup
./configure --prefix=/usr

%build
make CFLAGS="-g -O2" CXXFLAGS="-g -O2"

%install
make install-strip DESTDIR=${RPM_BUILD_ROOT}

%post
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

DESTDIR=${RPM_BUILD_ROOT} %{DATADIR}/scripts/inst-lpr-post.sh install
ln -fs %{DATADIR}/scripts/setup-lpr.sh %{DATADIR}/setup

%preun
if [ "$1" = 0 ] ; then
	DESTDIR=${RPM_BUILD_ROOT} %{DATADIR}/scripts/inst-lpr-post.sh deinstall
	rm -f %{DATADIR}/setup
fi

%postun
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

if [ "$1" = 0 ] ; then
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}/scripts
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}/rc.d
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DEAMONDIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{KOWADIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}/var/ekpd
fi

%files
%defattr(-,root,root)

%{BINDIR}/pips-spr800
%{BINDIR}/ekpstm
%{LIBDIR}/libspr800.so
#Delected
%{DEAMONDIR}/ekpd
%{DEAMONDIR}/gsconfig
%{DEAMONDIR}/dtrfilter
%{DEAMONDIR}/freset
%{DEAMONDIR}/paper_list.csv
%{DATADIR}/filter-spr800
%{ETCDIR}/ekpdrc
%{VARDIR}/ekpd/ekplp0
%{DATADIR}/readme-spr800
%{DATADIR}/libspr800.readme
%{BINDIR}/ekpnavi
%{DATADIR}/scripts/inst-lpr-post.sh
%{DATADIR}/lang

%{LOCALEDIR}/en/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/ja/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/de/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/es/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/fr/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/it/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/nl/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/pt/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/ko/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/zh/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/zh_TW/LC_MESSAGES/pips-spr800.mo

%{DATADIR}/scripts/setup-lpr.sh
%{DATADIR}/scripts/en.lc
%{DATADIR}/scripts/ja.lc

%{DATADIR}/inst-rc_d.sh
%{DATADIR}/rc.d/ekpd.redhat
%{DATADIR}/rc.d/ekpd.debian
%{DATADIR}/rc.d/ekpd.slackware
%{DATADIR}/rc.d/ekpd.local.slackware

%{DATADIR}/PATCH.PRN

%doc AUTHORS
%doc README
%doc COPYING
%doc COPYING.LIB
%doc COPYING.KOWA
%doc COPYING.KOWA.ja
%doc ChangeLog


%package -n pips-spr800-cups
Summary: Photo Image Print System for EPSON Stylus Photo R800 - CUPS version (i386)
Summary(ja): EPSON Stylus Photo R800 Ѥ Photo Image Print System - CUPSб (i386)
Group: System/Printer

#uncomment to remove dependency checks
AutoReqProv:   no
# Kondara requires
Requires: ld-linux.so.2
Requires: libX11.so.6
Requires: libXext.so.6
Requires: libXi.so.6
Requires: libc.so.6
Requires: libc.so.6(GLIBC_2.0)
Requires: libc.so.6(GLIBC_2.1)
Requires: libc.so.6(GLIBC_2.1.3)
#Requires: libcrypt.so.1
#Requires: libcrypto.so.0.9.6
Requires: libcups.so.2
Requires: libcupsimage.so.2
Requires: libdl.so.2
Requires: libdl.so.2(GLIBC_2.0)
Requires: libdl.so.2(GLIBC_2.1)
Requires: libgdk-1.2.so.0
Requires: libglib-1.2.so.0
Requires: libgmodule-1.2.so.0
Requires: libgtk-1.2.so.0
Requires: libjpeg.so.62
Requires: libm.so.6
Requires: libnsl.so.1
Requires: libpng.so.3
Requires: libpthread.so.0
Requires: libpthread.so.0(GLIBC_2.0)
Requires: libpthread.so.0(GLIBC_2.1)
#Requires: libssl.so.0.9.6
Requires: libtiff.so.3
Requires: libz.so.1

%description -n pips-spr800-cups

%post -n pips-spr800-cups
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

DESTDIR=${RPM_BUILD_ROOT} %{DATADIR}/scripts/inst-cups-post.sh install
ln -fs %{DATADIR}/scripts/setup-cups.sh %{DATADIR}/setup

%preun -n pips-spr800-cups
if [ "$1" = 0 ] ; then
	DESTDIR=${RPM_BUILD_ROOT} %{DATADIR}/scripts/inst-cups-post.sh deinstall
	rm -f %{DATADIR}/setup
fi

%postun -n pips-spr800-cups
if [ -x /sbin/ldconfig ]; then
	/sbin/ldconfig
fi

if [ "$1" = 0 ] ; then
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}/scripts
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}/rc.d
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DATADIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{DEAMONDIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}%{KOWADIR}
	rmdir --ignore-fail-on-non-empty ${RPM_BUILD_ROOT}/var/ekpd
fi

%files -n pips-spr800-cups
%defattr(-,root,root)

%{CUPS_SERVER_DIR}/filter/rastertopips
%{CUPS_SERVER_DIR}/filter/pipstoprinter
%{CUPS_SERVER_DIR}/backend/ekplp
%{CUPS_DATA_DIR}/model/ekspr800.ppd
%{LIBDIR}/libspr800.so
#Deleted
%{BINDIR}/ekpstm

%{DEAMONDIR}/ekpd
%{DEAMONDIR}/paper_list.csv
%{ETCDIR}/ekpdrc
%{VARDIR}/ekpd/ekplp0
%{DATADIR}/cupsopt.csv
%{DATADIR}/readme-spr800-cups
%{DATADIR}/libspr800.readme
%{DATADIR}/scripts/inst-cups-post.sh

%{LOCALEDIR}/en/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/ja/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/de/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/es/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/fr/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/it/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/nl/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/pt/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/ko/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/zh/LC_MESSAGES/pips-spr800.mo
%{LOCALEDIR}/zh_TW/LC_MESSAGES/pips-spr800.mo

%{DATADIR}/scripts/setup-cups.sh
%{DATADIR}/scripts/en.lc
%{DATADIR}/scripts/ja.lc

%{DATADIR}/inst-rc_d.sh
%{DATADIR}/rc.d/ekpd.redhat
%{DATADIR}/rc.d/ekpd.debian
%{DATADIR}/rc.d/ekpd.slackware
%{DATADIR}/rc.d/ekpd.local.slackware

%doc AUTHORS
%doc README
%doc COPYING
%doc COPYING.LIB
%doc COPYING.KOWA
%doc COPYING.KOWA.ja
%doc ChangeLog
