/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef INKBOX_H__
#define INKBOX_H__

#define INK_NUMBER 8	/* 2004.01.20 up to 8 */

enum Inkbox_Id
{
	INKBOX_K = 0,
	INKBOX_C,
	INKBOX_M,
	INKBOX_Y,
	INKBOX_LC,
	INKBOX_LM,
	INKBOX_DY,
	INKBOX_LK,
	INKBOX_MK,
	/* 2004.01.21 Added New Ink */
	INKBOX_R,	/* Red	    */
	INKBOX_V,	/* Violet   */
	INKBOX_CL	/* Clear    */
};

char ** inkbox_xpm_new (void);
void inkbox_xpm_ref (char **);
void inkbox_chenge_volume (char * [], unsigned long , int );
/* void inkbox_chenge_table (int); */

#endif

