/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include "pferr.h"

void
pf_error_outbreak (int eid, char* expr)
{
  if (eid == NO_ERROR)		/*  */
    return;

  fprintf(stderr, _("PIPS Error : "));
  if (expr != NULL)
    fprintf(stderr, "%s: ", expr);

  switch (eid)
    {
    case FILE_NOT_FOUND:
      fprintf(stderr, _("File not found.\n"));
      break;

    case NO_SUPPORT_ERROR:
      fprintf(stderr, _("Unsupported input format.\n"));
      break;

    case LIB_PNG_ERROR:
      fprintf(stderr, _("Input file is corrupt.\n"));
      break;

    case DLL_ERROR:
      fprintf(stderr, _("Can not find library.\n"));
      break;

    case LIBPRT_ERROR:
      fprintf(stderr, _("Library internal error\n"));
      break;

    case CONVERT_ERROR:
      fprintf(stderr, _("Format conversion error\n"));
      break;

    case MEMORY_ERROR:
      fprintf(stderr, _("Out of memory\n"));
    break;

    case UNEXPECTED_ERROR:
      fprintf(stderr, _("Unexpected error\n"));
    break;

    case ABNORMAL_END:
      fprintf(stderr, _("Was not able to print.\n"));
      break;

    case ATTRIBUTE_ERROR:
      fprintf(stderr, _("Illegal attribute value\n"));
      break;

    default:
      fprintf(stderr, _("Unknown error (%d).\n"), eid);
      if (expr != NULL)
	fprintf (stderr, "<< %s >>\n", expr);
      break;
    }

  return;
}
