/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __OPT_RSC__
#define __OPT_RSC__

#include "pipsDef.h"


/* Inset Defult */
#define	PIPS_INKSET_DEFAULT PIPS_INKSET_CMYKRVCl

#ifndef	_ONLY_NEED_DEFAULT_

/* Option Entry */
char *inkEntry[] = {
        "COLOR", "MONO",
        NULL
};

char *binEntry[] = {
        "AUTO", "ROLL", "TROLL", "T4AUTO",
        NULL
};

/* ASF */
char *mediaSizeEntry[] = {
        "A4", "B5", "A5", "LT", "LGL", "EXE", "HLT", "A6",
        "INDEX5", "INDEX8", "ENV10", "ENVDL", "ENVC6", "ENV5X8",
        "4X6FULL", "PP100", "PP200", "L", "2L", "PANORAM",
        NULL
};

/* ROLL */
char *mediaSizeEntry_R[] = {
        "A4", "B5", "A5", "EXE", "HLT", "A6",
        "INDEX5", "INDEX8", "4X6", "PP100", "L", "LL",
        "2L", "NC", "PANORAM",
        NULL
};

/* ROLL-Banner */
char *mediaSizeEntry_TR[] = {
        "A4", "4X6", "PP100", "L", "LL", "2L", "NC", "PANORAM",
        NULL
};

/* ASF-No Margin  */
char *mediaSizeEntry_NMA[] = {
	"A4", "INDEX5", "INDEX8", "4X6FULL", "PP100", "L", "2L", "PANORAM",
 	NULL
};

/* Manual */
char *mediaSizeEntry_M[] = {
	"A4",
 	NULL
};

/* Manual-No Margin  */
char *mediaSizeEntry_TM[] = {
	NULL
};

char *resolutionEntry[] = {
        "360", "720",
        NULL
};

char *mediaTypeEntry[] = {
        "PLAIN", "SFINE",  "ARCMATT", "PMMATT", "PMPHOTO", "PSGLOS",
        NULL
};

char *colorModeEntry[] = {
       "PHOTO", "GRAPH", "NONE",
        NULL
};

char *halftoneEntry[] = {
        "ED", "DB",
        NULL
};

char *levelEntry[] = {
        "DRAFT", "STD360","FINE720", "SFINE720", 
        "PHOTO1440", "PHOTO2880","SPHOTO1440","SPHOTO2880",
        NULL
};

char *multiPageEntry[] = {
        "1", "2", "4",
        NULL
};

char *autoCutEntry[] = {
        "NONE",
        NULL
};

char *clearInkEntry[] = {
        "OFF", "ON", "AUTO", "FULL",
        NULL
};

/* pModeCol     :       Color
   pModeMono    :       Monochrome

   MediaNumber  :       see pipsDef.h
   Input        :       1:120/180, 2:360, 4:720
   Halftone     :       <or> 1:ED 2:DB
   MicroWave    :       0:OFF 1:ON
   HighSpeed    :       0:OFF 1:ON 2:ON/OFF
   ClearInk     :       1:OFF 2:ON 4:AUTO 8:FULL
   Quality      :       0xXXX
                          ||+---- at Input 1
                          |+----- at Input 2
                          +------ at Input 4

*/
short pModeCol[] = {
        /* mediaName            Input           MicroWeave      Quality */
        /* & MediaNumber                Halftone        HighSpeed         ClearInk */
        /* PLAIN */
        PIPS_MED_PLAIN,         2,      2,      0,      1,       0x010,       1,
        PIPS_MED_PLAIN,         6,      2,      1,      2,       0x330,       3,
        PIPS_MED_PLAIN,         4,      1,      1,      2,       0x400,       3,

        /* SFINE */
        PIPS_MED_COATED720,     4,      1,      1,      2,       0x400,       1,

        /* ARCMATT */
        PIPS_MED_ARCHIVALMATTE, 4,      1,      1,      2,       0x400,       1,
        PIPS_MED_ARCHIVALMATTE, 4,      1,      1,      2,       0x600,       1,

        /* PMMATT */
        PIPS_MED_MATT_HEAVY,    4,      1,      1,      2,       0x400,       1,
        PIPS_MED_MATT_HEAVY,    4,      1,      1,      2,       0x600,       1,

        /* PMPHOTO */
        PIPS_MED_RC_PHOTO,      4,      1,      1,      2,       0x400,       13,
        PIPS_MED_RC_PHOTO,      4,      1,      1,      2,       0x600,       13,
        PIPS_MED_RC_PHOTO,      4,      1,      1,      2,       0x700,       13,

        /* PSGLOS */
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,       0x400,       13,
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,       0x600,       13,
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,       0x700,       13,
        -1
};

short pModeMono[] = {
        /* mediaName            Input           MicroWeave      Quality */
        /* & MediaNumber                Halftone        HighSpeed       ClearInk*/
        /* PLAIN */
        PIPS_MED_PLAIN,         2,      2,      0,      1,       0x010,       1,
        PIPS_MED_PLAIN,         6,      2,      1,      2,       0x330,       3,
        PIPS_MED_PLAIN,         4,      1,      1,      2,       0x400,       3,

        /* SFINE */
        PIPS_MED_COATED720,     4,      1,      1,      2,       0x400,       1,

        /* ARCMATT */
        PIPS_MED_ARCHIVALMATTE, 4,      1,      1,      2,       0x400,       1,
        PIPS_MED_ARCHIVALMATTE, 4,      1,      1,      2,       0x600,       1,

        /* PMMATT */
        PIPS_MED_MATT_HEAVY,    4,      1,      1,      2,       0x400,       1,
        PIPS_MED_MATT_HEAVY,    4,      1,      1,      2,       0x600,       1,

        /* PMPHOTO */
        PIPS_MED_RC_PHOTO,      4,      1,      1,      2,       0x400,       13,
        PIPS_MED_RC_PHOTO,      4,      1,      1,      2,       0x600,       13,
        PIPS_MED_RC_PHOTO,      4,      1,      1,      2,       0x700,       13,

        /* PSGLOS */
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,       0x400,       13,
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,       0x600,       13,
        PIPS_MED_PSEMIGLOSS,    4,      1,      1,      2,       0x700,       13,
        -1
};

/* Bin="T4AUTO" ̵ˤʤ⡼ID (color,black )*/
#define CHECK_PECULIAR_ALL
short de_param_mode_list[8][21] = { /* 21 = mode+1 */
	/* AUTO */
	{-1},
	/* ROLL */
	{0, -1},
	/* TROLL */
	{0,-1},
	/* TAUTO */
	{-1},
	/* T4AUTO */
	{0,-1},
	/* EXAUTO */
	{-1},
	/* MANUAL */
	{-1},
	/* MANUAL NoMargin */
	{-1}
};

#endif /* _ONLY_NEED_DEFAULT_ */

#endif /* __OPT_RSC__ */

