/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <limits.h>
#include "setup.h"

#define CONF_BUF_MAX 100
#define CONFIG_FILE_LENGTH_MAX 1024
#define KEY_WORD_MAX 20
const char CONFIG_FILE_PATH[] = "/etc/ekpdrc";

static void get_parameter (char*, char*, char*, int*);
static void clean_text (char*);

static char _printer_name[CONF_BUF_MAX];

void
get_prt_name (char *prt)
{
  strcpy (prt, _printer_name);
  return;
}

void
set_prt_name (char *prt)
{
  strcpy (_printer_name, prt);
  return;
}

int
init_prt_name (void)
{
  int fd;
  long len;
  char buf[CONFIG_FILE_LENGTH_MAX];

  memset (_printer_name, 0, CONF_BUF_MAX);

  fd = open (CONFIG_FILE_PATH, O_RDONLY);
  if (fd < 0)
    {
      perror (CONFIG_FILE_PATH);
      return 1;
    }

  len = (long)lseek (fd, (off_t)0, SEEK_END);
  if (len < CONFIG_FILE_LENGTH_MAX)
    {
      lseek (fd, (off_t)0, SEEK_SET);
      if (read (fd, buf, len) < 0)
	{
	  perror (CONFIG_FILE_PATH);
	  close (fd);
	  return 1;
	}
    }
  close (fd);

  clean_text (buf);
  get_parameter (buf, "PrinterName", _printer_name, NULL);

  if ((strlen (_printer_name)) == 0)
    return 1;

  return 0;
}

static void
get_parameter (char *buf, char *key, char *get_string, int *get_value)
{
  int len;
  char *tmp_buf;

  tmp_buf = strstr (buf, key);
  if (tmp_buf == NULL) return;

  tmp_buf += strlen (key);
  if (*tmp_buf != '=' || *(++tmp_buf) == '\0')
    {
      return;
    }
 
 len = strcspn (tmp_buf, " ");
  /* ʸǼ */
  if (get_string != NULL && len < CONF_BUF_MAX)
    {
      strncpy (get_string, tmp_buf, len);
    }
  /* ͳǼ (5=ͤκĹ) */
  if (get_value != NULL && len < 6)
    {
      char val_word [6];

      strncpy (val_word, tmp_buf, len);
      *get_value = atoi (val_word);
    }
  return;
}


static void
clean_text (char *buf)
{
  char *new_buf = buf;
  int i, j;
  
  j = 0;
  for (i = 0; buf[i] != '\0'; i++)
    {
      if (isspace (buf[i]))
	{
	  if (buf[i] == '\n')
	    new_buf[j++] = ' ';
	}
      else
	{
	  new_buf[j++] = buf[i];
	}
    }
  
  new_buf[j] = '\0';
  return;
}
