/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `ekpstm' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "ekpcom.h"
#include "stm.h"


/* Releasing the paper jam error  */
void
on_eject_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  char feedout_command[] = { 'p', 'j', 0x01, 0x00, 0x01 }; 
  int len;

  len = sizeof (feedout_command);
  sock_write_abandon_reply (feedout_command, &len);

  return;
}


/* releasing the paper out */
void
on_continue_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  char feedin_command[] = { 'p', 'e', 0x01, 0x00, 0x01 };
  int len;

  len = sizeof (feedin_command);
  sock_write_abandon_reply (feedin_command, &len);

  return;
}


/* reset printer */
void
on_reset_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  char reset_command[] = { 'r', 's', 0x01, 0x00, 0x01 };
  int len;

  len = sizeof (reset_command);
  sock_write_abandon_reply (reset_command, &len);

  return;
}


/* (unused) ink switching utility starting */
void
on_ink_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  system ("ekpnavi -i &");
  return;
}


/* job cancel */
void
on_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	/* When operation of lpr on ekpd becomes necessary, use "cancel".
	 * (use a "rs" command so.) */
#ifdef NO_ACTION
  char cancel_command[] = "cancel_nd4";	/* not CBT */
#else
  char cancel_command[] = "cancel"; /* CBT */
#endif
  int len;

  len = strlen (cancel_command);
  sock_write_abandon_reply (cancel_command, &len);

  set_cancel_status ();
  return;
}

/* end of status moniter */
void
on_close_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  end_stm ();
  return;
}

/* end of status moniter */
void
on_msg_ok_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  end_stm ();
  return;
}
