#!/bin/sh
# 
# Photo Image Print System
# Copyright (C) 2001-2004 EPSON KOWA Corporation.
# Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
# 
#  This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# 

if test -z $DESTDIR; then
    DESTDIR=
fi

PRINTER_MODEL_LOW=pm800c
PRINTER_MODEL=$(echo $PRINTER_MODEL_LOW | tr [:lower:] [:upper:])

PIPS_BIN_NAME=pips800
PIPS_FILTER_NAME=filter800

RM="rm -f"

PREFIX=$DESTDIR/usr
ETCDIR=$DESTDIR/etc
KOWADIR=$PREFIX/local/EPKowa
PKGDATADIR=$KOWADIR/$PRINTER_MODEL

MKDIR="mkdir -p"


if [ -x /usr/sbin/printconf-backend ]; then
    PRINTCAP=$DESTDIR/etc/printcap.local
else
    PRINTCAP=$DESTDIR/etc/printcap
fi


case "$1" in
    install)
	if [ ! -s $ETCDIR/pipsrc ]; then
	    touch $ETCDIR/pipsrc
	fi
	
	if [ ! -s $PRINTCAP ]; then
	    touch $PRINTCAP
	fi

	KEY=`grep $PRINTER_MODEL_LOW < ${PRINTCAP}`
	
	if [ -z "$KEY" ]; then
	    if [ -s $PRINTCAP ]; then
		cp $PRINTCAP $PRINTCAP.bak
	    fi
	    cat <<EOF >>$PRINTCAP
# written for $PIPS_BIN_NAME
${PRINTER_MODEL_LOW}:\\
    :sd=/var/spool/lpd/${PRINTER_MODEL_LOW}:\\
    :mx#0:\\
    :sh:\\
    :lp=/dev/lp0:\\
    :if=/usr/local/EPKowa/${PRINTER_MODEL}/$PIPS_FILTER_NAME:
# $PIPS_BIN_NAME  end
EOF
	    
	    $MKDIR $DESTDIR/var/spool/lpd/${PRINTER_MODEL_LOW}
	    
	    echo "Install Message > Described entry of ${PRINTER_MODEL_LOW} in printcap."
	    echo "Install Message > Backup file is ${PRINTCAP}.bak."
	fi
	
# printer reset
	CHECKPC=`whereis -b checkpc | sed -e "s/^.*:[[:space:]]*//"`
	if [ -n "$CHECKPC" -a -x "$CHECKPC" ] ; then
	    $CHECKPC -f 2>&1 1>/dev/null
	    echo "Install Message > Please restart lpd."
	    
	fi
	;;

    deinstall)
	if [ -s ${PRINTCAP} ]; then
	    KEY=`grep "\# written for $PIPS_BIN_NAME" ${PRINTCAP}`
	    if [ -n "$KEY" ]; then
		mv ${PRINTCAP} ${PRINTCAP}.bak
		
		SPOOLDIR=`cat $DESTDIR${PRINTCAP}.bak | sed -n "/# written for $PIPS_COMMAND/,/# $PIPS_COMMAND  end/p" | grep ":sd=" | sed -e "s/^.*:sd=//" -e "s/:.*$//"`
		rm -rf $SPOOLDIR
		
		sed -e "/# written for $PIPS_BIN_NAME/,/# $PIPS_BIN_NAME  end/d" < $DESTDIR${PRINTCAP}.bak > ${PRINTCAP}
	    fi
	fi
	
	if [ -d $DESTDIR/var/spool/lpd/${PRINTER_MODEL_LOW} ]; then
	    rm -rf $DESTDIR/var/spool/lpd/${PRINTER_MODEL_LOW}
	fi
	;;

    *)
	echo "Usage: install_post.sh { install | deinstall }" >&2
	exit 1
	;;
esac
