/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __GSCONFIG_H__
#define __GSCONFIG_H__

#define BUFMAX 0xff
#define LBUFMAX 0xffff

typedef int BOOL;
enum nOPTION
{
  ID_INK = 0,
  ID_RESOL,
  ID_MSIZE
};

const int Param_Num = 4;
const char* Params[] = { "ink", "resolution", "mediasize", "papersource" };

const int Ink_Num = 2;
const char* Inks[] = {
  "COLOR", "MONO"
};

const int Bin_Num = 6;
const char* Bins[] = {
  "AUTO", "ROLL", "TROLL", "TR3300", "TR820", "TAUTO"
};

typedef struct _MEDIA_SIZE_STRUCT
{
  char* name;
  int x;
  int y;
} MSL_STRUCT, *LP_MSL_STRUCT;

typedef struct _GS_CONF_STRUCT
{
  int format;			/*  */
  int resolution;		/*  */
  long media_size_x;		/* ǥ() */
  long media_size_y;		/* ǥ() */
} GS_CONF, *LP_GS_CONF;

GS_CONF Def_Conf = { 1, 360, 2976, 4209 };

MSL_STRUCT Media_Size[] = {
  /* PaperName          PaperID         PaperSize(dot) */
  							
  /* A4 */          {   "A4",           2976,   4209   },
  /* B5 */          {   "B5",           2580,   3643   },
  /* B4 */          {   "B4",           3643,   5159   },
  /* A5 */          {   "A5",           2098,   2976   },
  /* A3 */          {   "A3",           4209,   5953   },
  /* A3+ */         {   "A3+",          4663,   6846   },
  /* A6 */          {   "A6",           1488,   2098   },
  /* PHOTOCARD */   {   "PHOTO",        1610,   2330   },
  /* POSCARD */     {   "PC",           1417,   2098   },
  /* DPOSCARD */    {   "DPC",          2835,   2098   },
  /* EnvC3 */       {   "ENVC3",        1701,   3685   },
  /* EnvC4 */       {   "ENVC4",        1276,   3161   },
  /* EnvY1 */       {   "ENVY1",        1701,   2494   },
  /* EnvY2 */       {   "ENVY2",        1616,   2296   },
  /* EnvY3 */       {   "ENVY3",        1389,   2098   },
  /* EnvY4 */       {   "ENVY4",        1488,   3331   },
  /* Letter */      {   "LT",           3060,   3960   },
  /* Legal */       {   "LGL",          3060,   5040   },
  /* 4x6 */         {   "4X6",          1417,   2160   },
  /* L size */      {   "L",            1261,   1800   },
  /* NCARD */       {   "NC",           1261,    779   },
                    {  "", 0, 0  }
};

#endif /* __GSCONFIG_H__ */
