/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __LIB_PRT_X_H__
#define __LIB_PRT_X_H__

#include <dlfcn.h>
#include "pipsdef.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define DLL_PRT_INIT  "libprt_init"
#define DLL_PAGE_INIT "libprt_page_init"
#define DLL_BAND_OUT  "libprt_out"
#define DLL_PAGE_END  "libprt_page_end"
#define DLL_PRT_END   "libprt_end"

/* init¤ -libraryνɬ */
typedef struct _LIBPRT_INIT_STRUCT
{
  FILE* output;
  char* paper;
  char* format;
  char* resol;
  char* high_speed;
  char* bin_id;
  char* media_type;
  char* qlevel;
  POINT margin;
  POINT paper_size;
  POINT paper_area;
  void* reserved;               /* reserved */
} LIBPRT_INIT, *LP_LIBPRT_INIT;

/* page init¤ -pageɬ */
typedef struct _LIBPRT_PAGE_STRUCT
{
  char* color_mode;
  char* halftone_type;
  int brightness;
  int contrast;
  int saturation;
  int r_strength;
  int g_strength;
  int b_strength;
  void* reserved;               /* reserved */
} LIBPRT_PAGE, *LP_LIBPRT_PAGE;

/* band¤ -ºݤbandϤݤɬ */
typedef struct _LIBPRT_BAND_STRUCT
{
  long width_pixel;
  long width_bytes;
  long line_number;
  unsigned char* byte_data;
  void* reserved;               /* reserved */
} LIBPRT_BAND, *LP_LIBPRT_BAND;

typedef int (*INIT_FUNC)(HANDLE*,LP_LIBPRT_INIT);
typedef int (*PINIT_FUNC)(HANDLE, LP_LIBPRT_PAGE);
typedef int (*OUT_FUNC)(HANDLE, LP_LIBPRT_BAND);
typedef int (*PEND_FUNC)(HANDLE, int);
typedef int (*END_FUNC)(HANDLE);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __LIB_PRT_X_H__ */
