/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __PIPSDEF_H__
#define __PIPSDEF_H__

#define MODE_ITEM 5
enum MODE_OFSET
{
	MOFS_MEDIA = 0,
	MOFS_INPUT,
	MOFS_HALFTONE,
	MOFS_HIGH_SPEED,
	MOFS_QUALITY
};

/* output type */
enum eOUTPUT_FORMAT
{
  PIPS_OUTPUT_MONO = 0,
  PIPS_OUTPUT_CMYKcm
};

/* ink set */
enum eINKSET
{
  PIPS_INKSET_DEFAULT = 0,
  PIPS_INKSET_CMYK,
  PIPS_INKSET_CMYKcm,
  PIPS_INKSET_CMYKcmDY
};

/* media size */
enum ePAPER_SIZE
{
  PIPS_PAPER_LETTER = 0,
  PIPS_PAPER_LEGAL,
  PIPS_PAPER_A3,
  PIPS_PAPER_A3_PLUS,
  PIPS_PAPER_A4,
  PIPS_PAPER_A5,
  PIPS_PAPER_B4,
  PIPS_PAPER_B5,
  PIPS_PAPER_A6_INDEX,
  PIPS_PAPER_POSTCARD_SNGL,
  PIPS_PAPER_POSTCARD_DBL,
  PIPS_PAPER_PHOTO_PRINT,
  PIPS_PAPER_JENV_CHOU3,
  PIPS_PAPER_JENV_CHOU4,
  PIPS_PAPER_JENV_YOU1,
  PIPS_PAPER_JENV_YOU2,
  PIPS_PAPER_JENV_YOU3,
  PIPS_PAPER_JENV_YOU4,
  PIPS_PAPER_TRIM_4X6,
  PIPS_PAPER_TRIM_L,
  PIPS_PAPER_TRIM_NAMECARD,
  PIPS_PAPER_TRIM_2L,
  PIPS_PAPER_TRIM_LL,
  PIPS_PAPER_EXECUTIVE,
  PIPS_PAPER_HALF_LETTER,
  PIPS_PAPER_INDEXCARD5,
  PIPS_PAPER_INDEXCARD8,
  PIPS_PAPER_ENV_10,
  PIPS_PAPER_ENV_DL,
  PIPS_PAPER_ENV_C6,
  PIPS_PAPER_ENV_FOR5X8,
  PIPS_PAPER_PHOTO_100x150,
  PIPS_PAPER_PHOTO_200x300,
  PIPS_PAPER_4X6FULL,
  PIPS_PAPER_PANORAMIC
};


/* media type */
enum eMEDIA_TYPE
{
  PIPS_MED_PLAIN = 0,
  PIPS_MED_COATED360,
  PIPS_MED_COATED720,
  PIPS_MED_TRANSPARENCY,
  PIPS_MED_GLOSSYFILM,
  PIPS_MED_GLOSSYPAPER,
  PIPS_MED_BACKPRINT,
  PIPS_MED_IRON_PRINT = 14,
  PIPS_MED_RC_PHOTO = 18,
  PIPS_MED_MATT_HEAVY = 23,
  PIPS_MED_CD_R = 35,
  PIPS_MED_MAT_BOARD = 37,
  PIPS_MED_NEW_SF = 46,
  PIPS_MED_CLPP = 51,
  PIPS_MED_BWIP,
  PIPS_MED_DBS_MATTE,
  PIPS_MED_ARCHIVALMATTE,
  PIPS_MED_PSEMIGLOSS,
  PIPS_MED_PHOTOWEIGHT,
  PIPS_MED_ESF,
  PIPS_MED_EPP,
  PIPS_MED_IJPC,
  PIPS_MED_RCPC,  
  PIPS_MED_GLOSSYPHOTOPAPER,
  PIPS_MED_MCLP
 
};

/* micro weave */
enum eMICRO_WEAVE
{
  PIPS_MW_OFF = 0,
  PIPS_MW_ON
};

/* high speed */
enum eHIGH_SPEED
{
  PIPS_HS_OFF = 0,
  PIPS_HS_ON
};

/* color mode */
enum eCOLOR_MODE
{
  PIPS_CMM_PHOTO = 0,
  PIPS_CMM_GRAPH,
  PIPS_CMM_AUTO,
  PIPS_CMM_NONE
};

/* halftone */
enum eHALFTONE
{
  PIPS_HT_QUALITY = 0,
  PIPS_HT_SPEED,
  PIPS_HT_NONE
};

/* feeder */
enum eFEEDER
{
  PIPS_BIN_AUTO = 0,
  PIPS_BIN_USER,
  PIPS_BIN_TRIMBANNER,
  PIPS_BIN_AUTO_TRIM,
  PIPS_BIN_AUTO_TRIM_4,
  PIPS_BIN_AUTO_EX
};

/* quality level set pattern bits */
enum eQUALITY
{
  PIPS_LV_DRAFT = 0,
  PIPS_LV_STD,
  PIPS_LV_FINE,
  PIPS_LV_SFINE,
  PIPS_LV_PHOTO,
  PIPS_LV_SPHOTO,
  PIPS_LV_SILENT
};

#ifndef __PIPS_DEF_H__
typedef unsigned int UINT;
typedef unsigned short USHORT;
typedef unsigned long ULONG;
typedef unsigned char UCHAR;
typedef struct tagPOINT
{
  long  x;
  long  y;
} POINT, *PPOINT, *LPPOINT;
#endif /* __PIPS_DEF_H__ */

typedef int (*func_t)(UCHAR *, void *, void *, void *);


#endif /* __PIPSDEF_H__ */
