/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __X_MODE_H__
#define __X_MODE_H__

#include "pips.h"
#if USE_GTK
#include <gtk/gtk.h>
#include <glib.h>
#endif

#include "libintl.h"
#define _(magic_words) gettext (magic_words)

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define INPUT 0
#define OUTPUT 1
#if USE_GTK

#define GTK_BORDER 3

	typedef struct _RADIO_PACK{
		int id;
		GtkWidget *label;
		GtkWidget *pixmap;
		GSList *group;
	} RADIO_PACK;
  
	typedef struct _CHECK_PACK{
		int id;
		int flag;
		GtkWidget *pixmap;
		GtkWidget *check;
	} CHECK_PACK;
  
	typedef struct _SELECT_PACK{
		int id;
		GtkWidget *pixmap;
		GtkWidget *label;
		GtkWidget *optmenu;
		GtkWidget *hbox;
	} SELECT_PACK;
  
	typedef struct _SPIN_PACK{
		int id;
		GtkWidget *pixmap;
		GtkWidget *label;
		GtkObject *adj;
		GtkWidget *spin;
	} SPIN_PACK;
  
	typedef struct _ADJUSTMENT_PACK{
		int id;
		GtkWidget *pixmap;
		GtkWidget *label;
		GtkObject *adj;
		GtkWidget *entry;
		GtkWidget *hscale;
		double max;
		double min;
	} ADJUSTMENT_PACK;
#endif
	extern char *inkEntry[];
	extern char *mediaSizeEntry[];
	extern char *mediaTypeEntry[];
	extern char *resolutionEntry[];
	extern char *colorModeEntry[];
	extern char *halftoneEntry[];
	extern char *dotEntry[];
	extern char *levelEntry[];

#ifdef ROLL_PAPER
	extern char *mediaSizeEntry_R[];

#if !(PM820_3300C)
	extern char *mediaSizeEntry_TR[];
#else
	extern char *mediaSizeEntry_TR_PM3300C[];
	extern char *mediaSizeEntry_TR_PM820C[];
#endif
#if (PM820C)
	extern char *mediaSizeEntry_TA[];
#endif

	extern char *binEntry[];
#endif /* ROLL_PAPER */

	extern short pModeCol[];
	extern short pModeMono[];

	extern char *highRanckLabels[];
	extern char *ioLabels[];
	extern char *finishButtonLabels[];
	extern char *outputTypeLabels;
	extern char *outputLabels[];
	extern char *def_margin_label;
	extern OPTION_ALL opt_all[];
  
	char* commonLabelCall(int, OPTION_DATA*);
	void commonSetOptionsSensitive(void);
#if USE_GTK
	GtkWidget* radioPackNew(char*, char*[], int);
	GtkWidget* checkPackNew(char*, int);
	GtkWidget* selectPackNew(char*, char*[], int);
	GtkWidget* spinPackNew(char*, int, double[]);
	GtkWidget* adjustmentPackNew(char*, int, double[]);
	GtkWidget* ioPackNew(char*, int);
#ifdef CONV_VERSION2
	GtkWidget*
	margin_default_set_button (void);
#endif /* CONV_VERSION2 */

#endif

	void optionsUpdata(int);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __X_MODE_H__ */
