/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __OPT_RSC__
#define __OPT_RSC__

#include "pips.h"

/* Option Entry */
char *inkEntry[] = {
  "COLOR",      "MONO",
  NULL
};

char *binEntry[] = {
  "AUTO", "ROLL", "TROLL",
  NULL
};

char *mediaSizeEntry[] = {
  "A4", "B5", "A5", "A6", "PHOTO", "PC", "DPC", "ENVC3",
  "ENVC4", "ENVY1", "ENVY2", "ENVY3", "ENVY4", "LT", "LGL",
  NULL
};

char *mediaSizeEntry_R[] = {
  "A4", "B5", "A5", "A6", "PC", "DPC", "LT",
  "LGL", "4X6", "L", "NC",
  NULL
};

char *mediaSizeEntry_TR[] = {
  "PC", "4X6", "L", "NC",
  NULL
};


char *resolutionEntry[] = {
  "120", "360", "720",
  NULL
};

char *mediaTypeEntry[] = {
  "PLAIN", "SFINE", "GPAPER", "GFILM",
  "OHP", "IRON", "PMPHOTO",
  NULL
};

char *colorModeEntry[] = {
  "PHOTO", "GRAPH", "NONE",
  NULL
};

char *halftoneEntry[] = {
  "ED", "DB",
  NULL
};

char *levelEntry[] = {
  "DRAFT", "STD", "FINE", "SFINE", "PHOTO", "SPHOTO",
  NULL
};


/* pModeCol     :       ColorѰ⡼
   pModeMono    :       MonochromeѰ⡼

   MediaNumber  :       pipsDef.h 
   Inmput       :       1:120, 2:360, 4:720
   Halftone     :       <or> 1:ED 2:DB
   HighSpeed    :       0:OFF 1:ON 2:ON/OFF
*/
short pModeCol[] = {
18,
/*mediaName             MediaNumber                     Halftone
                                                Input           HighSpeed */
/*PLAIN*/               PIPS_MED_PLAIN,         1,      2,      1,      0x000,
                        PIPS_MED_PLAIN,         2,      3,      2,      0x010,
                        PIPS_MED_PLAIN,         2,      3,      2,      0x020,
                        PIPS_MED_PLAIN,         6,      3,      2,      0x330,
                        PIPS_MED_PLAIN,         6,      3,      2,      0x440,
/*COATED720*/           PIPS_MED_COATED720,     6,      3,      2,      0x220,
                        PIPS_MED_COATED720,     6,      3,      2,      0x330,
                        PIPS_MED_COATED720,     4,      3,      2,      0x400,
/*GLOSSYPAPER*/         PIPS_MED_GLOSSYPAPER,   6,      3,      2,      0x220,
                        PIPS_MED_GLOSSYPAPER,   6,      3,      2,      0x330,
                        PIPS_MED_GLOSSYPAPER,   4,      3,      2,      0x400,
/*GLOSSYFILM*/          PIPS_MED_GLOSSYFILM,    6,      3,      0,      0x330,
                        PIPS_MED_GLOSSYFILM,    4,      3,      0,      0x400,
/*TRANSPARENCY*/        PIPS_MED_TRANSPARENCY,  2,      2,      0,      0x010,
/*IRON_PRINT*/          PIPS_MED_IRON_PRINT,    2,      3,      0,      0x010,
/*P_PHOTO*/             PIPS_MED_RC_PHOTO,      6,      3,      2,      0x220,
                        PIPS_MED_RC_PHOTO,      6,      3,      2,      0x330,
                        PIPS_MED_RC_PHOTO,      4,      3,      2,      0x400,
};

short pModeMono[] = {
18,
/*mediaName             MediaNumber                     Halftone
                                                Input           HighSpeed */
/*PLAIN*/               PIPS_MED_PLAIN,         1,      1,      1,      0x000,
                        PIPS_MED_PLAIN,         2,      1,      2,      0x010,
                        PIPS_MED_PLAIN,         2,      1,      2,      0x020,
                        PIPS_MED_PLAIN,         6,      1,      2,      0x330,
                        PIPS_MED_PLAIN,         6,      1,      2,      0x440,
/*COATED720*/           PIPS_MED_COATED720,     6,      1,      2,      0x220,
                        PIPS_MED_COATED720,     6,      1,      2,      0x330,
                        PIPS_MED_COATED720,     4,      1,      2,      0x400,
/*GLOSSYPAPER*/         PIPS_MED_GLOSSYPAPER,   6,      1,      2,      0x220,
                        PIPS_MED_GLOSSYPAPER,   6,      1,      2,      0x330,
                        PIPS_MED_GLOSSYPAPER,   4,      1,      2,      0x400,
/*GLOSSYFILM*/          PIPS_MED_GLOSSYFILM,    6,      1,      0,      0x330,
                        PIPS_MED_GLOSSYFILM,    4,      1,      0,      0x400,
/*TRANSPARENCY*/        PIPS_MED_TRANSPARENCY,  2,      1,      0,      0x010,
/*IRON_PRINT*/          PIPS_MED_IRON_PRINT,    2,      1,      0,      0x010,
/*P_PHOTO*/             PIPS_MED_RC_PHOTO,      6,      1,      2,      0x220,
                        PIPS_MED_RC_PHOTO,      6,      1,      2,      0x330,
                        PIPS_MED_RC_PHOTO,      4,      1,      2,      0x400,
};

#endif /* __OPT_RSC__ */
