/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __PAPER_RSC__
#define __PAPER_RSC__

#include "paper.h"
#define LIST_END { NULL, -1, -1, -1, -1, -1, -1 }

/* ASF */
PAPER_CONF paper_auto[] = {
/* A4 210 x 297 mm */                { "A4",    2976,   4209,   2892,   3969,	42,	 42 },
/* A5 148 x 210 mm */                { "A5",    2098,   2976,   2014,   2736,	42,	 42 },
/* A6 105 x 148 mm */                { "A6",    1488,   2098,   1404,   1858,	42,	 42 },
/* A3 297 x 420 mm */                { "A3",    4209,   5953,   4125,   5713,	42,	 42 },
/* A3 Ɏˎ 329 x 483 mm */            { "A3+",   4663,   6846,   4579,   6606,	42,	 42 },
/* B5 182 x 257 mm */                { "B5",    2580,   3643,   2496,   3403,	42,	 42 },
/* B4 257 x 364 mm */                { "B4",    3643,   5159,   3559,   4919,	42,	 42 },
/* ϥ 100 x 148 mm */            { "PC",    1417,   2098,   1333,   1858,	42,	 42 },
/* ϥ 200 x 148 mm */        { "DPC",   2835,   2098,   2751,   1858,	42,	 42 },
/* ̎ĎĎ 102 x 152 mm */           { "PHOTO", 1610,   2330,   1526,   2246,	42,	 42 },
/* Ĺ3 120 x 235 mm */       { "ENVC3", 1701,   3685,   1617,   3091,	42,	396 },
/* Ĺ4 90 x 205 mm */        { "ENVC4", 1276,   3161,   1192,   2666,	42,	297 },
/* η1 120 x 176 mm */       { "ENVY1", 1701,   2494,   1617,   2254,	42,	 42 },
/* η2 114 x 162 mm */       { "ENVY2", 1616,   2296,   1532,   2056,	42,	 42 },
/* η3 98 x 148 mm */        { "ENVY3", 1389,   2098,   1305,   1858,	42,	 42 },
/* η4 105 x 235 mm */       { "ENVY4", 1488,   3331,   1404,   3091,	42,	 42 },
/* Letter 8 1/2 x 11 in */           { "LT",    3060,   3960,   2976,   3720,	42,	 42 },
/* Legal 8 1/2 x 14 in */            { "LGL",   3060,   5040,   2976,   4800,	42,	 42 },
                                     LIST_END
};

/* Roll */							
PAPER_CONF paper_roll[] = {
/* A4 210 x 297 mm */                { "A4",    2976,   4209,   2892,   4209,	42,	  0 },
/* A5 148 x 210 mm */                { "A5",    2098,   2976,   2014,   2976,	42,	  0 },
/* A6 105 x 148 mm */                { "A6",    1488,   2098,   1404,   2098,	42,	  0 },
/* A3 297 x 420 mm */                { "A3",    4209,   5953,   4125,   5953,	42,	  0 },
/* A3 Ɏˎ 329 x 483 mm */            { "A3+",   4663,   6846,   4579,   6846,	42,	  0 },
/* B5 182 x 257 mm */                { "B5",    2580,   3643,   2496,   3643,	42,	  0 },
/* B4 257 x 364 mm */                { "B4",    3643,   5159,   3559,   5159,	42,	  0 },
/* ϥ 100 x 148 mm */            { "PC",    1417,   2098,   1333,   2098,	42,	  0 },
/* ϥ 200 x 148 mm */        { "DPC",   2835,   2098,   2751,   2098,	42,	  0 },
/* Letter 8 1/2 x 11 in */           { "LT",    3060,   3960,   2976,   3960,	42,	  0 },
/* Legal 8 1/2 x 14 in */            { "LGL",   3060,   5040,   2976,   5040,	42,	  0 },
/* 4x6  100 x 152 mm */            { "4X6",   1417,   2160,   1333,   2160,	42,	  0 },
/* L 89 x 127 mm */                { "L",     1261,   1800,   1177,   1800,	42,	  0 },
/* ̾ 89 x 55 mm */                { "NC",    1261,    779,   1177,    779,	42,	  0 },
                                     LIST_END
};

/* Roll (trim) */						
PAPER_CONF paper_roll_trim[] = {
/* A4 210 x 297 mm */                { "A4",    2976,   4209,   3047,   4209,	0,	  0 },
/* ϥ 100 x 148 mm */            { "PC",    1417,   2098,   1488,   2098,	0,	  0 },
/* 4x6  100 x 152 mm */            { "4X6",   1417,   2160,   1488,   2160,	0,	  0 },
/* L 89 x 127 mm */                { "L",     1261,   1800,   1332,   1800,	0,	  0 },
/* ̾ 89 x 55 mm */                { "NC",    1261,    779,   1332,    779,	0,	  0 },
                                     LIST_END
};

/* ASF (trim) */						
PAPER_CONF paper_auto_trim[] = {
/* A4 210 x 297 mm */                { "A4",    2976,   4209,   3047,   3969,	0,	 42 },
/* ϥ 100 x 148 mm */            { "PC",    1417,   2098,   1488,   1858,	0,	 42 },
                                     LIST_END
};

#endif /* __PAPER_RSC__ */
