/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include "pferr.h"

void
pf_error_outbreak (int eid, char* expr)
{
  if (eid == NO_ERROR)		/*  */
    return;

  fprintf (stderr, "pips error: ");
  if (expr != NULL)
    fprintf (stderr, "%s: ", expr);

  switch (eid)
    {
    case FILE_NOT_FOUND:	/* ꤵ줿ե뤬դʤ */
      fprintf (stderr, "File not found.\n");
      break;

    case NO_SUPPORT_ERROR:	/* ݡȤʤΥե뤬
				   Ϥ줿 */
      fprintf (stderr, "It is processing is failed.\n");
      break;

    case LIB_PNG_ERROR:		/* libpng˥顼 */
      fprintf (stderr, "PNG processing is failed.\n");
      break;

    case DLL_ERROR:		/* DLL˼ */
      fprintf (stderr, "Dynamic library processing is failed.\n");
      break;

    case LIBPRT_ERROR:		/* libprtΥ顼 */
      fprintf (stderr, "An error is occurred in the library.\n");
      break;

    case CONVERT_ERROR:		/* Ѵ˼ */
      fprintf (stderr, "Convert processing is failed.\n");
      break;

    case MEMORY_ERROR:		/* ꡼γݤ˼ */
    fprintf(stderr, "No allocate memory\n");
    break;

    case UNEXPECTED_ERROR:	/* ͽ̥顼 */
    fprintf(stderr, "Unexpected error is occurred.\n");
    break;

    case ABNORMAL_END:		/* ۾ｪλ */
      fprintf (stderr, "...Abort\n");
      break;

    default:
      fprintf (stderr, "Unknown error (%d).\n", eid);
      if (expr != NULL)
	fprintf (stderr, "<< %s >>\n", expr);
      break;
    }

  return;
}
