/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifndef __PF_ERR_H__
#define __PF_ERR_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define PF_ERROR_HANDLER(eid, expr) pf_error_outbreak (eid, expr)

  enum nPF_ERRORS {
    NO_ERROR = 0,		/*  */
    FILE_NOT_FOUND,		/* ꤵ줿ե뤬դʤ */
    NO_SUPPORT_ERROR,		/* ݡȤʤΥե뤬
				   Ϥ줿 */
    LIB_PNG_ERROR,		/* libpng˥顼 */
    DLL_ERROR,			/* DLL˼ */
    LIBPRT_ERROR,		/* libprtΥ顼 */
    CONVERT_ERROR,		/* Ѵ˼ */
    MEMORY_ERROR,		/* ꡼γݤ˼ */
    UNEXPECTED_ERROR,		/* ͽ̥顼 */
    ABNORMAL_END,		/* ۾ｪλ */
  };

void
pf_error_outbreak (int, char*);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __PF_ERR_H__ */
