/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `ekpd' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission
 * to link the code of this program with the `cbt' library and
 * distribute linked combinations including the two.  You must obey
 * the GNU General Public License in all respects for all of the
 * code used other then `cbt'.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <limits.h>
#include "cbtd.h"

#define CONFIG_FILE_LENGTH_MAX 1024 /* Maximum size of configuration file */
#define KEY_WORD_MAX 20		/* Maximum size of attribute title */
const char CONFIG_FILE_PATH[] = "/etc/ekpdrc"; /* configuration file path */


static void get_parameter (char*, char*, char*, int*);
static void clean_text (char*);


/* initialize system */
int
parameter_setup (P_CBTD_INFO p_info)
{
	int fd;
	long len;
	char buf[CONFIG_FILE_LENGTH_MAX];

	fd = open (CONFIG_FILE_PATH, O_RDONLY);
	if (fd < 0)
	{
		_DEBUG_FUNC(perror (CONFIG_FILE_PATH));
		return 1;
	}

	len = (long)lseek (fd, (off_t)0, SEEK_END);
	if (len < CONFIG_FILE_LENGTH_MAX)
	{
		lseek (fd, (off_t)0, SEEK_SET);
		if (read (fd, buf, len) < 0)
		{
			_DEBUG_FUNC(perror (CONFIG_FILE_PATH));
			close (fd);
			return 1;
		}
	}

	close (fd);
	clean_text (buf);

	/* Printer Setting name */
	get_parameter (buf, "PrinterName", p_info->printer_name, NULL);
	/* The path of the device driver the printer is connected */
	get_parameter (buf, "PrinterDevicePath", p_info->devprt_path, NULL);
	/* Dummy device for printing */
	get_parameter (buf, "DummyDevicePath", p_info->infifo_path, NULL);
	/* Number of the communication port */
	get_parameter (buf, "CommandServerPort", NULL, &p_info->comsock_port);

	if (*(p_info->printer_name) == 0
	    || *(p_info->devprt_path) == 0
	    || *(p_info->infifo_path) == 0
	    || p_info->comsock_port < 0
	    || p_info->comsock_port > UINT_MAX)
		return 1;

	return 0;
}


/* get settings */
static void
get_parameter (char *buf, char *key, char *get_string, int *get_value)
{
	int len;
	char *tmp_buf;

	tmp_buf = strstr (buf, key);
	if (tmp_buf == NULL) return;

	tmp_buf += strlen (key);
	if (*tmp_buf != '=' || *(++tmp_buf) == '\0')
	{
		return;
	}
 
	len = strcspn (tmp_buf, " ");
	if (get_string != NULL && len < CONF_BUF_MAX)
	{
		strncpy (get_string, tmp_buf, len);
	}

	/* 5 = the greatest number of digits */
	if (get_value != NULL && len < 6)
	{
		char val_word [6];

		strncpy (val_word, tmp_buf, len);
		*get_value = atoi (val_word);
	}
	return;
}


/* fix data in buffer */
static void
clean_text (char *buf)
{
	char *new_buf = buf;
	int i, j;
  
	j = 0;
	for (i = 0; buf[i] != '\0'; i++)
	{
		if (isspace (buf[i]))
		{
			if (buf[i] == '\n')
				new_buf[j++] = ' ';
		}
		else
		{
			new_buf[j++] = buf[i];
		}
	}
  
	new_buf[j] = '\0';
	return;
}
