/*
 * Photo Image Print System
 * Copyright (C) 2002-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2002-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <str.h>
#include <getstat.h>
#include <ekpcom.h>

int
get_status (char *buf)
{
	char status_command[]  = { 's', 't', 0x01, 0x00, 0x01 };
	int nwrite, nread;

	if (sock_open () != 0)
		return 1;

	buf[0] = '\0';

	nwrite = sizeof (status_command);
	nread = 0;
	if (sock_write (status_command, &nwrite) < 0)
	{
		sock_reopen ();
		nwrite = sizeof (status_command);
		sock_write (status_command, &nwrite);
	}
	
	if (nwrite > 0)
	{
		nread = REPLAY_SIZE;
		sock_read (buf, &nread);
		buf[nread] = '\0';
	}

	sock_close();

	if (buf[0]) /* no error */
		return 0;
	/* error */
	return 1;
}

#define OFFSET_FIRST_INK_CARTRIDGE 4
#define OFFSET_SEVENTH_INK_CARTRIDGE 34

char *
get_inkset_str (void)
{
	char buf[REPLAY_SIZE];
	char* point;
	int c, m, y, k, lc, lm, dy;
	char ic[5];

	c = m = y = k = lc = lm = dy = 0;
	get_status (buf);
	
	point = strstr (buf, "INK:");

	if (point == NULL) {
		return str_clone ("DEFAULT", strlen ("DEFAULT"));
	}

	point += 4;	/* skip "INK:" */
	while (*point != ';') {
		memcpy(ic, point, 4);
		*(ic + 4) = '\0';
		switch (atoi(ic)) {
		case 1101:
		case 1140:
			k++; break;
		case 3202:
			c++; break;
		case 4304:
			m++; break;
		case 5408:
			y++; break;
		case 6210:
			lc++; break;
		case 7320:
			lm++; break;
		case 9440:
			dy++; break;
		default:
			return str_clone ("DEFAULT", strlen ("DEFAULT"));
			break;
		}
		point += 4;
		if( point >= (buf+REPLAY_SIZE) ){
			break;
		}
		if( *point == ',' ) point++;
	}
	
	if (dy) {
		return str_clone ("CMYKcmDY", strlen ("CMYKcmDY"));
	} else if (lc && lm) {
		return str_clone ("CMYKcm", strlen ("CMYKcm"));
	} else {
		return str_clone ("CMYK", strlen ("CMYK"));
	}

	return str_clone ("DEFAULT", strlen ("DEFAULT"));
}
