/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `ekpstm' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __EKPCOM_H__
#define __EKPCOM_H__

enum _ERROR_PACKET_NUMBERS
{
  NOERR = 0,			/* no error */
  UNKNOWN_PACKET,		/* unknown packet */
  PRINTER_DOWN,			/* printer is not connected */
  SYSTEM_HUNG = 16		/* ekpd does not start */
};


/* public functions */

/*
 * Parameter   : none
 * Returns     : returns zero on success, or -1 if an error occurred.
 * Description : open a socket and start a communication with ekpd.
 */
int sock_open (void);
/*
 * Parameter   : none
 * Returns     : none
 * Description : close a socket and end a communication with ekpd.
 */
void sock_close (void);
/*
 * Parameter   : buf      -pointer to write data buffer.
 *               lp_wsize -on success, the number of bytes write is returned.
 * Returns     : returns zero on success, or -1 if an error occurred.
 * Description : send a packet of data to ekpd.
 */
int sock_write (char*, int*);
/*
 * Parameter   : buf      -pointer to read data buffer
 *               lp_wsize -on success, the number of bytes read is returned.
 * Returns     : returns zero on success, or -1 if an error occurred.
 * Description : receive a packet of data from ekpd.
 */
int sock_read (char*, int*);
/*
 * Parameter   : none
 * Returns     : returns zero on success, or -1 if an error occurred.
 * Description : reopen a socket and restart a communication with ekpd.
 */
int sock_reopen (void);
/*
 * Parameter   : buf      -pointer to write data buffer.
 *               lp_wsize -on success, the number of bytes read is returned.
 * Returns     : returns zero on success, or -1 if an error occurred.
 * Description : version to ignore reply of sock_write.
 */
int sock_write_abandon_reply (char*, int*);

#endif /* __EKPCOM_H__ */
