#!/bin/sh
# 
# Photo Image Print System
# Copyright (C) 2002-2004 EPSON KOWA Corporation.
# Copyright (C) SEIKO EPSON CORPORATION 2002-2004.

if test -z $DESTDIR; then
    DESTDIR=
fi

PRINTER_MODEL=PM900C

PREFIX=$DESTDIR/usr
KOWADIR=$PREFIX/local/EPKowa
PKGDATADIR=$KOWADIR/$PRINTER_MODEL

SYSCONFDIR=$DESTDIR/etc
SCRIPTDIR=$PKGDATADIR/rc.d
INSTALL="install -m 755"
LN="ln -sf"
RM="rm -f"

#
# Check distribution
#


if [ -d $SYSCONFDIR/rc.d ]; then
    rcdir=$SYSCONFDIR/rc.d

    if [ -d $SYSCONFDIR/rc.d/init.d ]; then
	funcdir=$SYSCONFDIR/rc.d/init.d

	if [ -f $SYSCONFDIR/rc.d/init.d/functions ]; then
	    rctype=redhat

	else
	    rctype=other

	fi

    else
	if [ -d $SYSCONFDIR/init.d -a -x /sbin/start-stop-daemon ]; then
	    funcdir=$SYSCONFDIR/init.d
	    rcdir=$SYSCONFDIR
	    rctype=debian

	else
	    funcdir=$SYSCONFDIR/rc.d
	    rctype=slackware

	fi
    fi

else
    rcdir=$SYSCONFDIR
    if [ -d $SYSCONFDIR/init.d -a -x /sbin/start-stop-daemon ]; then
	funcdir=$SYSCONFDIR/init.d
	rctype=debian

    else
	funcdir=$SYSCONFDIR
	rctype=other

    fi
fi

# Other -> Slackware (default)
if [ $rctype = "other" ]; then
    rctype=slackware
fi

case "$1" in
    #
    # Install script
    #
    install)
	if [ $rctype = "redhat" ]; then
	    $INSTALL $SCRIPTDIR/ekpd.redhat $funcdir/ekpd

	elif [ $rctype = "debian" ]; then
	    $INSTALL $SCRIPTDIR/ekpd.debian $funcdir/ekpd

	elif [ $rctype = "slackware" -a -f $funcdir/rc.local ]; then
	    cat $SCRIPTDIR/ekpd.local.slackware >> $funcdir/rc.local
	    $INSTALL $SCRIPTDIR/ekpd.slackware $funcdir/rc.ekpd

	else
	    echo Error : Unknow linux distribution
	    exit 1
	fi

	for loop in 2 3 4 5 S M ; do
	    if [ -d $rcdir/rc$loop.d ]; then
		$LN $funcdir/ekpd $rcdir/rc$loop.d/S11ekpd

	    elif [ -d $rcdir/rc.$loop ]; then
		$LN $funcdir/ekpd $rcdir/rc.$loop/S11ekpd

	    fi
	done
	for loop in 0 1 6 K ; do
	    if [ -d $rcdir/rc$loop.d ]; then # not slackware
		$LN $funcdir/ekpd $rcdir/rc$loop.d/K89ekpd

	    elif [ -d $rcdir/rc.$loop ]; then
		$LN $funcdir/ekpd $rcdir/rc.$loop/K89ekpd

	    fi
	done
	;;

    deinstall)
	for loop in 2 3 4 5 S M ; do
	    if [ -s $rcdir/rc$loop.d/S11ekpd ]; then
		$RM $rcdir/rc$loop.d/S11ekpd

	    elif [ -s $rcdir/rc.$loop/S11ekpd ]; then
		$RM $rcdir/rc.$loop/S11ekpd

	    fi
	done
	for loop in 0 1 6 K ; do
	    if [ -s $rcdir/rc$loop.d/K89ekpd ]; then # not slackware
		$RM $rcdir/rc$loop.d/K89ekpd

	    elif [ -s $rcdir/rc.$loop/K89ekpd ]; then
		$RM $rcdir/rc.$loop/K89ekpd

	    fi
	done

		if [ -s $funcdir/ekpd ]; then
	    $RM $funcdir/ekpd

	elif [ -s $funcdir/rc.ekpd ]; then
	    $RM $funcdir/rc.ekpd

	fi

	if [ $rctype = "slackware" -a -s $funcdir/rc.local ]; then
	    KEY=`grep "# ekpd starting script #start" $funcdir/rc.local`
	    if [ -n "$KEY" ]; then
		mv $funcdir/rc.local $funcdir/rc.local.bak
		sed -e "/# ekpd starting script #start/,/# ekpd starting script #end/d" < $funcdir/rc.local.bak > $funcdir/rc.local
		chmod 755 $funcdir/rc.local
	    fi
	fi

	;;

    checkdist)
	echo $rctype
	;;

    *)
	echo "Usage: install-rc_d.sh { install | deinstall | checkdist }" >&2
	exit 1
	;;
esac

exit 0;
