/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __GSCONFIG_H__
#define __GSCONFIG_H__

#define BUFMAX 0xff
#define LBUFMAX 0xffff

typedef int BOOL;
enum nOPTION
{
  ID_INK = 0,
  ID_RESOL,
  ID_MSIZE,
  ID_BIN
};

const int Param_Num = 4;
const char* Params[] = { "ink", "resolution", "mediasize", "papersource" };

const int Ink_Num = 2;
const char* Inks[] = {
  "COLOR", "MONO"
};

typedef struct _GS_CONF_STRUCT
{
  int format;			/*  */
  int resolution;		/*  */
  long media_size_x;		/* ǥ() */
  long media_size_y;		/* ǥ() */
} GS_CONF, *LP_GS_CONF;

GS_CONF Def_Conf = { 1, 360, 2976, 4209 };

#endif /* __GSCONFIG_H__ */
