/*
 * Photo Image Print System
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifndef __OPT_RSC__
#define __OPT_RSC__

#include "pipsDef.h"

/* Option Entry */
char *inkEntry[] = {
  "COLOR", "MONO",
  NULL
};

char *binEntry[] = {
  "AUTO", "ROLL", "TROLL", "T4AUTO",
  NULL
};

char *mediaSizeEntry[] = {
  "A4", "B5", "A5", "A6", "PHOTO", "PC", "DPC", "L", "ENVC3",
  "ENVC4", "ENVY1", "ENVY2", "ENVY3", "ENVY4", "LT", "LGL",
  NULL
};

char *mediaSizeEntry_R[] = {
  "A4",	"B5", "A5", "A6", "PC",	"DPC", "LT", "L", "2L", "LL",
  "LGL", "4X6", "NC",
  NULL
};

char *mediaSizeEntry_TR[] = {
  "A4", "PC", "L", "2L", "LL", "4X6", "NC",
  NULL
};

char *mediaSizeEntry_NMA[] = {
  "A4", "PC", "L", "2L",
  NULL
};

char *resolutionEntry[] = {
  "180", "360", "720",
  NULL
};

char *mediaTypeEntry[] = {
  "PLAIN", "SFINE", "GPAPER", "PMPHOTO", "PMMATT",
  "OHP", "GFILM", "IRON", "MBOARD",
  NULL
};

char *colorModeEntry[] = {
  "PHOTO", "GRAPH", "NONE",
  NULL
};

char *halftoneEntry[] = {
  "ED",
  NULL
};

char *levelEntry[] = {
  "DRAFT", "STD", "FINE", "PHOTO",
  NULL
};


/* pModeCol	:	ColorѰ⡼
   pModeMono	:	MonochromeѰ⡼

   MediaNumber	:	pipsDef.h 
   Inmput	:	1:180, 2:360, 4:720
   Halftone	:	<or> 1:ED 2:DB
   HighSpeed	:	0:OFF 1:ON 2:ON/OFF
*/
short pModeCol[] = {
19,
/*mediaName		MediaNumber	Halftone
     				Input		HighSpeed */
/*PLAIN*/		0,	1,	1,	1,	0x000,
			0,	2,	1,	2,	0x010,
			0,	2,	1,	2,	0x020,
			0,	6,	1,	2,	0x440,

/*COATED720*/		2,	2,	1,	2,	0x010,
			2,	6,	1,	2,	0x220,

/*GLOSSYPAPER*/		5,	2,	1,	2,	0x010,
			5,	6,	1,	2,	0x220,
			5,	4,	1,	0,	0x400,

/*PM_PHOTO*/            18,	6,	1,	2,	0x220,
			18,	4,	1,	0,	0x400,

/*PM_MATT*/             23,	2,	1,	2,	0x010,
			23,	6,	1,	2,	0x220,
			23,	4,	1,	0,	0x400,

/*GLOSSYFILM*/		4,	6,	1,	0,	0x220,
			4,	4,	1,	0,	0x400,

/*TRANSPARENCY*/        3,      2,      1,      0,      0x010,

/*IRON_PRINT*/		14,	2,	1,	0,	0x010,

/*MATT_BOARD*/          37,     2,      1,      0,      0x010
};

short pModeMono[] = {
19,
/*mediaName		MediaNumber	Halftone
     				Input		HighSpeed */
/*PLAIN*/		0,	1,	1,	1,	0x000,
			0,	2,	1,	2,	0x010,
			0,	2,	1,	2,	0x020,
			0,	6,	1,	2,	0x440,

/*COATED720*/		2,	2,	1,	2,	0x010,
			2,	6,	1,	2,	0x220,

/*GLOSSYPAPER*/		5,	2,	1,	2,	0x010,
			5,	6,	1,	2,	0x220,
			5,	4,	1,	0,	0x400,

/*PM_PHOTO*/            18,	6,	1,	2,	0x220,
			18,	4,	1,	0,	0x400,

/*PM_MATT*/             23,	2,	1,	2,	0x010,
			23,	6,	1,	2,	0x220,
			23,	4,	1,	0,	0x400,

/*GLOSSYFILM*/		4,	6,	1,	0,	0x220,
			4,	4,	1,	0,	0x400,

/*TRANSPARENCY*/        3,      2,      1,      0,      0x010,

/*IRON_PRINT*/		14,	2,	1,	0,	0x010,

/*MATT_BOARD*/          37,     2,      1,      0,      0x010
};


/* ξˤꡢ⡼ɼΤѹɬפȤʤ˻Ѥ롣
   äformat¸ߤʤʲϴ˵¸εҤǤꡢ¾ε
   Ȥθߴ̵*/

/* Bin="T4AUTO" ̵ˤʤ⡼ID (color,black )*/
short de_param_mode_t4_for_pm900c[] = {
  0, 1, 14, 15, 16, 17, 18, -1
};

#endif /* __OPT_RSC__ */


