/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <math.h>
#include "pfimg.h"
#include "pips.h"
#include "paper.h"

static BOOL
change_prtinfo (LP_PRT_STRUCT, SEP_INIT_PARAM*);
static char*
change_resource (int, int);

int
graphics_converter_version2 (SEP_INIT_PARAM *lp_sepip, char* input, char* output)
{
  MKC_STRUCT mk_str;
  PRT_STRUCT prtinfo;

  char* input_files[] = { NULL, NULL };
  char lib_path[] = LIBPATH;

  if (strcmp (input, "STDIN"))
    {
      input_files[0]  = input;
      mk_str.input_files = input_files;
    }
  else
    {
      mk_str.input_files = NULL;
    }

  mk_str.output_file = output;
  mk_str.libprt_path = lib_path;

  if (change_prtinfo (&prtinfo, lp_sepip))
    return 1;
  mk_str.lp_prtinfo = &prtinfo;

  return (int)make_code_process (&mk_str);
  /* return 0; */
}

static BOOL
change_prtinfo (LP_PRT_STRUCT lp_prtinfo, SEP_INIT_PARAM *lp_sepip)
{
  int resol;
  LP_PAPER_CONF lp_pconf;

  lp_prtinfo->paper         = change_resource (P_MEDIA_SIZE, (int)lp_sepip->paper_id);
  lp_prtinfo->ink           = change_resource (P_INK, lp_sepip->prt_format);
  lp_prtinfo->src_resol     = change_resource (P_RESOLUTION, lp_sepip->src_resolution.x);
  lp_prtinfo->high_speed    = change_resource (P_HIGH_SPEED, lp_sepip->high_speed);
  lp_prtinfo->bin_id        = change_resource (P_BIN, lp_sepip->bin_id);
  lp_prtinfo->media_type    = change_resource (P_MEDIA_TYPE, lp_sepip->media_type);
  lp_prtinfo->color_mode    = change_resource (P_COLOR_MODE, lp_sepip->color_correction);
  lp_prtinfo->halftone_type = change_resource (P_HALF_TONE, lp_sepip->halftone_type);
  lp_prtinfo->qlevel        = change_resource (P_QUALITY_LEVEL, lp_sepip->qlevel);
  
  lp_prtinfo->brightness = lp_sepip->brightness;
  lp_prtinfo->contrast   = lp_sepip->contrast;
  lp_prtinfo->saturation = lp_sepip->saturation;
  lp_prtinfo->r_strength = lp_sepip->r_strength;
  lp_prtinfo->g_strength = lp_sepip->g_strength;
  lp_prtinfo->b_strength = lp_sepip->b_strength;
  lp_prtinfo->ratio.x  = lp_sepip->mag;
  lp_prtinfo->ratio.y  = lp_prtinfo->ratio.x;

  if (!strcmp (lp_prtinfo->bin_id, ""))
    {
      OPTION_DATA* lp_data;

      lp_data = databasesCall (CALL_FOR_RSC_NAME, P_BIN, (void*)"AUTO");
      lp_prtinfo->bin_id = lp_data->rsc_name;
    }

  lp_pconf = call_paper_conf (lp_prtinfo->bin_id, lp_prtinfo->paper);
  if (lp_pconf == NULL)
    return 1;

  resol = lp_sepip->src_resolution.x;
    
  lp_prtinfo->margin.x = MM_TO_DOT(lp_sepip->margin.x) * resol / 360;
  lp_prtinfo->margin.y = MM_TO_DOT(lp_sepip->margin.y) * resol / 360;
  if (strcmp (lp_prtinfo->bin_id, "AUTO")
      && strcmp (lp_prtinfo->bin_id, "ROLL"))
    {
      lp_prtinfo->margin.x = 0;
      if (!strcmp (lp_prtinfo->bin_id, "T4AUTO"))
	{
	  lp_prtinfo->margin.y = 0;
	}
    }

  lp_prtinfo->paper_size.x     = lp_pconf->size_x * resol / 360;
  lp_prtinfo->paper_size.y     = lp_pconf->size_y * resol / 360;
  lp_prtinfo->paper_area.x     = lp_pconf->area_x * resol / 360;
  lp_prtinfo->paper_area.y     = lp_pconf->area_y * resol / 360;
  lp_prtinfo->default_margin.x = lp_pconf->margin_x * resol / 360;
  lp_prtinfo->default_margin.y = lp_pconf->margin_y * resol / 360;

  return 0;
}

static char*
change_resource (int id, int val)
{
  OPTION_DATA* lp_data;

  lp_data = databasesCall (CALL_FOR_VALUE, id, (void*)(&val));
  return lp_data->rsc_name;
}
