/*
 * Photo Image Print System
 * Copyright (C) 2000-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2004.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON KOWA Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON KOWA PUBLIC LICENCE and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON KOWA PUBLIC LICENCE.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include "pipsError.h"

int pipsError(char *edata, int ecode){

  if(ecode == NO_ERROR) return 0;

  if(ecode == RESOURCE_ERROR){
    fprintf(stderr, "PIPS Error : Line %s : Resourcefile load error\n", edata);
    return 0;
  }

  fprintf(stderr, "PIPS Error : ");
  if(edata != NULL) fprintf(stderr, "%s : ", edata);

  switch(ecode){

  case NO_OPTION_ERROR: // ץ¸ߤʤ
    fprintf(stderr, "The option does not exist\n");
    break;

  case OPTION_LESS_ERROR: // ץΰʤ
  case OPTION_VALUES_ERROR: // ץͤ,
    fprintf(stderr, "The value of option is wrong\n");
    break;

  case DUB_FILENAME_ERROR: // ϥեλ꤬İʾ夢
    fprintf(stderr, "Tow or more input files was designated\n");
    break;

  case CONNECTION_ERROR: // ץȹ礻ѥθ
    fprintf(stderr, "The combination of the option is wrong\n");
    break;

  case RESOURCE_FORM_ERROR: // 񼰴ְ㤤
    fprintf(stderr, "A form is wrong\n");
    break;    

  case NO_RESOURCE_ERROR: // ꥽¸ߤʤ
    fprintf(stderr, "The resource does not exist\n");
    break;

  case RESOURCE_LESS_ERROR: // ꥽ΰʤ
  case RESOURCE_VALUES_ERROR: // ꥽ͤ,
    fprintf(stderr, "The value of resource is wrong\n");
    break;

  case GRAPHICS_LOAD_ERROR: // եΥɤ˼
    fprintf(stderr, "Failed in the load of a graphics\n");
    break;

  case NO_SUCH_LIBRARY: // library̵
  case NO_FILE_ERROR:
    fprintf(stderr, "File not found\n");
    break;

  case FAILED_FILE_ERROR: // եΥץ˼
    fprintf(stderr, "Open the file is failed\n");
    break;

  case GRAPHICS_FORMAT_ERROR:	// 
    fprintf(stderr, "The data format is unsupported\n");
    break;

  case NOT_COMMUNICATE_LPR_ERROR: // lprȤ̿˼
    fprintf(stderr, "Communication to lpr is failed\n");
    break;

  case LIBRARY_PARAM_ERROR: // libraryΰ顼
    fprintf(stderr, "The parameter of library is wrong\n");
    break;

  case MEMORY_ERROR:
    fprintf(stderr, "No allocate memory\n");
    break;
    
  case UNEXPECTED_ERROR: // ͽ̥顼(̿Ū)
    fprintf(stderr, "Unexpected error is occured\n");
    break;

  case ABNORMAL_END: // ۾ｪλ
    fprintf(stderr, "...ABEND\n");
    break;

  default:
	fprintf( stderr, "Unknown error occurd(%d).\n", ecode ); 
	break;
  }
  if ( stderr )
    fflush( stderr );
  return ecode;
}

