/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `ekpnavi' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __NAVI_H__
#define __NAVI_H__

enum _NAVI_TYPE
{
  DOT_ALIGNMENT = 1,
  INK_CHENGE,
  AUTOCUT_ABJUSTMENT
};

enum _INK_SELECT
{
  INK_BLACK,
  INK_COLOR,
  INK_ALL
};


typedef struct _DD_PARAM
{
	char bid_id;
	char color;
	char unit;
} DD_PARAM, * LP_DD_PARAM;

void set_platen (void);

void init_navi (GtkWidget *, int);
void end_navi (void);
void destroy_navi (GtkWidget*, gpointer);

void init_alignment (char*, int, int, int, char*, char*, char*, char*);
void init_cartridge (int);
void init_align_autocut (char*, char*, char*);

int get_navi_page (void);
void set_navi_page (int);

#endif /* __NAVI_H__ */
