/*
 * Photo Image Print System
 * Copyright (C) 2001-2004 EPSON KOWA Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2001-2004.
 *
 * This file is part of the `ekpnavi' program.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "msg.h"

const char msg_no_black_strings[] = N_("Black cartridge is not installed in the cartridge holder.");
const char msg_no_color_strings[] = N_("Color cartridge is not installed in the cartridge holder.");
const char msg_no_connect_strings[] = N_("A communication error has occurred.\nClick OK and then check the interface cable type, all cable connections and make sure\nthat all devices are on. If the error persists, unplug the printer then plug it in again.");
const char msg_no_idle_strings[] = N_("The printer is printing, or occurs a error. If it is printing, wait until printing is completed.\nIf it occurs a error, clear the error and start Ink cartridge change utility again.");
const char msg_no_inkall_strings[] = N_("Black or color cartridge is not installed in the cartridge holder.");


GtkWidget *
create_msg_dialog_with_type (enum MSG_TYPE type)
{
	GtkWidget *dialog;
	GtkWidget *label;
	gchar *strings = "";

	dialog = create_msg_dialog ();

	
	label = lookup_widget (dialog, "msg_label");

	switch (type)
	{
	case MSG_NO_BLACK: strings = (gchar *)msg_no_black_strings; break;
	case MSG_NO_COLOR: strings = (gchar *)msg_no_color_strings; break;
	case MSG_NO_INKALL: strings = (gchar *)msg_no_inkall_strings; break;
	case MSG_NO_CONNECT: strings = (gchar *)msg_no_connect_strings; break;
	case MSG_NO_IDLE: strings = (gchar *)msg_no_idle_strings; break;
	default: break;
	}

	gtk_label_set_text      (GTK_LABEL(label), strings);

	return dialog;
}
